/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.config;

import java.util.Collection;

import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
/**
 * Interface for validating an xml given it's xsd or dtd.
 * 
 * @author kstam
 * @author ddegroff
 *
 */
public interface XmlValidator 
{
	/**
	 * Validates an xml for it's wellformedness.
	 * 
	 * @param xmlInputSource of the xml that needs to be validated.
	 * @return boolean, true if  it passed validation, false if it failed.
	 * @throws XmlValidatorException
	 */
	public boolean validate(InputSource xmlInputSource) throws XmlValidatorException;
	/**
	 * Validates an xml using the xsd or dtd given in the second argument.
	 * 
	 * @param xmlInputSource of the xml that needs to be validated.
	 * @param validationSource to the xsd or dtd.
	 * @return boolean, true if  it passed validation, false if it failed.
	 * @throws XmlValidatorException
	 */
	public boolean validate(InputSource xmlInputSource, StreamSource validationSource) throws XmlValidatorException;
	/**
	 * If the validation fails, more details can be obtained about the reasons why.
	 * 
	 * @return Collection Strings
	 */
	public Collection<String> getValidationResults();
	/**
	 * After validation the parsed document can be obtained for further processing.
	 * 
	 * @return Document, the parsed XML Document.
	 */
	public Document getXMLDocument();
}
