/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.lifecycle;

/**
 * Lifecycle priorities.
 * 
 * This class contains priority values for core resources.  The  
 * resources are cleaned in order from lowest to highest value.
 *
 * @author kevin
 */
public final class LifecyclePriorities
{
    /**
     * The rule base priority.
     */
    public static final int RULE_BASE_PRIORITY = 50000;
    
    /**
     * The courier priority.
     */
    public static final int COURIER_PRIORITY = 100000 ;
    
    /**
     * The JMS connection pool priority.
     */
    public static final int JMS_CONNECTION_POOL_PRIORITY = 200000 ;
    
    /**
     * The Naming Context pool priority.
     */
    public static final int NAMING_CONTEXT_POOL_PRIORITY = 400000 ;
}
