/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.couriers;

import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.message.Message;
/**
 * Courier interface. Deals relatively low level Message transport options.
 * 
 * @author esteban
 * @author kstam@redhat.com
 *
 */
public interface Courier extends DeliverOnlyCourier
{
	/**
	 * Try to deliverAsync an ESB message. This is a one shot delivery.
	 * 
	 * @param message Message - the message to deliverAsync
	 * @return boolean - the result of the delivery
	 * @throws CourierException - if problems were encountered
	 */
	public boolean deliver(Message message) throws CourierException, MalformedEPRException;
}
