/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions.templates;

import java.text.SimpleDateFormat;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.Util;


/**
 * Use this class to tune your XML configurations <p/>Once your config works
 * with this dummy class, you can switch to your own action class <p/>You will
 * have to implement these three methods in your own action class
 * 
 * @author Esteban
 * 
 */
public class MockAction 
{
    /**
     * Class Logger.
     */
    private static Logger logger = Logger.getLogger(MockAction.class);

    public Message process(Message message) 
    {
    	Object oCurr = null;
    	if (null==message)
    		oCurr = "null";
    	else
	    	try { oCurr = Util.serialize(message); }
	    	catch (Exception e) 
	    		{ oCurr = message.toString();}
        logger.info(getStamp() + " process was called with <<" + oCurr.toString() + ">>");
        return message;
    } // ________________________________

    private SimpleDateFormat s_oTS = new SimpleDateFormat(
            "yyyy/MM/dd hh:mm:ss.SSS");

    private String getStamp() {
        return s_oTS.format(new java.util.Date(System.currentTimeMillis()));
    }

} // ____________________________________________________________________________
