/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions.routing;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.ActionUtils;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;

/**
 * Echo Action Processor. 
 * 
 * <p/> Sample Action Configuration:
 * 
 * <pre>
 *   &lt;Action class=&quot;org.jboss.soa.esb.actions.routing.EchoRouter&quot;&gt;&lt;/Action&gt;
 * </pre>
 * 
 * @author <a href="mailto:johan.kumps@telenet.be">Johan Kumps</a>
 */
public class EchoRouter extends AbstractActionPipelineProcessor {

	/* The logger for this class */
	private static Logger logger = Logger.getLogger(EchoRouter.class);
    private MessagePayloadProxy payloadProxy;

    public EchoRouter (ConfigTree configTree){
        payloadProxy = new MessagePayloadProxy(configTree,
                                               new String[] {BytesBody.BYTES_LOCATION, ActionUtils.POST_ACTION_DATA},
                                               new String[] {ActionUtils.POST_ACTION_DATA});
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jboss.soa.esb.actions.ActionProcessor#process(java.lang.Object)
	 */
	public org.jboss.soa.esb.message.Message process(
			org.jboss.soa.esb.message.Message message)
			throws ActionProcessingException {
	    
		if (logger.isInfoEnabled()) {
            Object content;
            
            try {
                content = payloadProxy.getPayload(message);
            } catch (MessageDeliverException e) {
                throw new ActionProcessingException(e);
            }

            logger.info("EchoRouter currently routing message " + message + " with payload <<" + content + ">>");
		}

		return message;

	}
}
