/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions;

import org.jboss.soa.esb.message.Message;

/**
 * Exception while processing message payload processing action. Can be
 * used to return an application specific fault message and break out
 * of action chaining loop.
 * 
 * @author marklittle
 * @since Version 4.2MR2
 */
public class ActionProcessingFaultException extends ActionProcessingException
{

	private static final long serialVersionUID = 1L;

	public ActionProcessingFaultException (Message faultMessage, String cause)
	{
		this(cause);
		
		_message = faultMessage;
	}
	
	/**
	 * Public constructor.
	 * 
	 * @param message
	 *            Exception message.
	 */
	public ActionProcessingFaultException(String message)
	{
		super(message);
	}

	/**
	 * Public constructor.
	 * 
	 * @param message
	 *            Exception message.
	 * @param cause
	 *            Exception cause.
	 */
	public ActionProcessingFaultException(String message, Throwable cause)
	{
		super(message, cause);
	}

	/**
	 * Public constructor.
	 * 
	 * @param cause
	 *            Exception cause.
	 */
	public ActionProcessingFaultException(Throwable cause)
	{
		super(cause);
	}

	public final Message getFaultMessage ()
	{
		return _message;
	}
	
	private Message _message;
}
