/**
 * A Base64 Encoder/Decoder.
 *
 * <p>
 * This class is used to encode and decode data in Base64 format as described in RFC 1521.
 *
 * <p>
 * This is "Open Source" software and released under the <a href="http://www.gnu.org/licenses/lgpl.html">GNU/LGPL</a> license.<br>
 * It is provided "as is" without warranty of any kind.<br>
 * Copyright 2003: Christian d'Heureuse, Inventec Informatik AG, Switzerland.<br>
 * Home page: <a href="http://www.source-code.biz">www.source-code.biz</a><br>
 *
 * <p>
 * Version history:<br>
 * 2003-07-22 Christian d'Heureuse (chdh): Module created.<br>
 * 2005-08-11 chdh: Lincense changed from GPL to LGPL.<br>
 * 2006-11-21 chdh:<br>
 *  &nbsp; Method encode(String) renamed to encodeString(String).<br>
 *  &nbsp; Method decode(String) renamed to decodeString(String).<br>
 *  &nbsp; New method encode(byte[],int) added.<br>
 *  &nbsp; New method decode(String) added.<br>
 */

package org.jboss.internal.soa.esb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import org.apache.commons.codec.binary.Base64;
import org.jboss.soa.esb.util.ContextObjectInputStream;

public class Encoding
{	
	/*
	 * The following are methods added by us to support Objects.
	 */
	
	public static String encodeBytes (byte[] param)
	{
		return new String(Base64.encodeBase64(param));
	}

	public static byte[] decodeToBytes (String param)
	{
		return Base64.decodeBase64(param.getBytes());
	}
	
	public static String encodeObject (Serializable object) throws IOException
	{
		if (object == null)
			throw new IllegalArgumentException();
		
		ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bs);
        
        oos.writeObject(object);
        oos.close();
        
        return encodeBytes(bs.toByteArray());
	}
	
	public static Serializable decodeToObject (String param) throws IOException, ClassNotFoundException
	{
		if (param == null)
			throw new IllegalArgumentException();
		
		ContextObjectInputStream ois = null;
		
		try
		{
			ByteArrayInputStream bs = new ByteArrayInputStream(Base64.decodeBase64(param.getBytes()));
			ois = new ContextObjectInputStream(bs);

			return (Serializable) ois.readObject();
		}
		finally
		{
			ois.close();
		}
	}

}
