/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;

/**
 * ESB Properties.
 * <p/>
 * Loads the properties resource from either of filesystem, URL or classpath.
 * See {@link StreamUtils#getResource(String)}.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ESBProperties extends Properties {

    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ESBProperties.class);

    public ESBProperties(String propertiesResource) throws ConfigurationException {
        InputStream config = StreamUtils.getResource(propertiesResource);

        try {
            load(config);
        } catch (IOException e) {
            throw new ConfigurationException("Error reading '" + propertiesResource + "'.", e);
        } finally {
            try {
                config.close();
            } catch (IOException e) {
                logger.warn("Failed to close stream to '" + propertiesResource + "'.");
            }
        }
    }

    public int getIntProperty(String key, int defaultVal) {
        String value = getProperty(key);

        if(value == null) {
            return defaultVal;
        }

        try {
            return Integer.parseInt(value.trim());
        } catch(NumberFormatException e) {
            logger.error("Invalid property value format for property '" + key + "'.  Integer value expected.  Actual value '" + value + "'.");
            return defaultVal;
        }
    }
}
