package org.jboss.internal.soa.esb.message.format.xml;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.message.Header;

/**
 * The message header. Contains such things as routing information.
 */

public class HeaderImpl extends ElementContent implements Header
{
	public HeaderImpl ()
	{
		_call = new Call();
	}
	
        /**
         * Construct a header from the input stream.
         * 
         * @param in The input stream.
         * @throws XMLStreamException For errors during parsing.
         */
	public HeaderImpl(final XMLStreamReader in)
	    throws XMLStreamException
	{
	    final CallImpl callImpl = new CallImpl(in) ;
	    _call = callImpl.getCall() ;
	}
	
	// TODO add other setters/getters for artibitrary attributes
	
	public Call getCall ()
	{
		return _call;
	}
	
	public void setCall (Call call)
	{
		if (call == null)
			throw new IllegalArgumentException();
		
		_call = call;
	}
	
	public String toString ()
	{
		if (_call != null)
			return "header: [ "+_call.toString()+" ]";
		else
			return "header: [  ]";
	}
	
        /**
         * Write the child content of the element.
         * @param out The output stream.
         * @throws XMLStreamException For errors during output.
         */
	@Override
	protected void writeChildContent(XMLStreamWriter out)
	        throws XMLStreamException
	{
	    if (_call != null)
	    {
	        final CallImpl callImpl = new CallImpl(_call) ;
	        callImpl.writeContent(out) ;
	    }
	}
	
	@Override
	protected void putElement(XMLStreamReader in, QName elementName)
	        throws XMLStreamException
	{
	        throw new XMLStreamException("Unexpected element name: " + elementName) ;
	}
	
	private Call _call;
}