/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 */

package org.jboss.internal.soa.esb.message.format;

/**
 * Exception thrown for errors occurring during deferred deserialisation of values.
 * 
 * @author <a href='kevin.conner@jboss.com'>Kevin Conner</a>
 */

public class DeferredDeserialisationException extends RuntimeException
{
    /**
     * The serial version UID for this exception.
     */
    private static final long serialVersionUID = -8941603736543453117L;

    /**
     * Construct a default deferred deserialisation exception.
     */
    public DeferredDeserialisationException()
    {
        super() ;
    }
    
    /**
     * Construct a deferred deserialisation exception.
     * @param message The message associated with the exception.
     */
    public DeferredDeserialisationException(final String message)
    {
        super(message) ;
    }
    
    /**
     * Construct a deferred deserialisation exception.
     * @param cause The origianl cause of the exception.
     */
    public DeferredDeserialisationException(final Throwable cause)
    {
        super(cause);
    }
    
    /**
     * Construct a deferred deserialisation exception.
     * @param message The message associated with the exception.
     * @param cause The origianl cause of the exception.
     */
    public DeferredDeserialisationException(final String message, final Throwable cause)
    {
        super(message, cause) ;
    }
}
