/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.internal.soa.esb.couriers.helpers;

import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.couriers.CourierException;

public class FileHandlerFactory 
{
	private static final FileHandlerFactory _instance = new FileHandlerFactory();

	public static FileHandlerFactory getInstance() { return _instance; }

	public FileHandler getFileHandler(FileEpr epr) throws CourierException
	{
		if (epr instanceof FTPEpr) 	return new FtpFileHandler	((FTPEpr)epr);

		//TODO  Maybe ftps and sftp ?  Wait for Bruno's input

		//  if flow falls through, last option should be local file handler
		if (epr instanceof FileEpr)	return new LocalFileHandler	((FileEpr)epr);

		throw new CourierException("Unable to obtain a file handler for supplied EPR");
	}
	
}
