/**
 * 
 */
package org.jboss.soa.esb.oracle.aq;


import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.FileInputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Properties;

import javax.sql.DataSource;

import org.junit.Before;
import org.junit.Test;

/**
 * @author kstam
 *
 */
public class DatasourceTest 
{
    private final static String Q_NAME = "org.jboss.soa.esb.oracle.aq.q.name";
    private String user, password, server, instance, schema, driver, portStr, qName;
    private int port;
    /**
     * Tests for completeness of the properties needed ro make a db connection.
     *
     */
    @Test
    public void checkPropertiesInFile() 
    {
            System.out.println("user=" + user + ", password=" + password + ", server=" + server
                    + ", port=" + portStr + ", qName=" + qName
                    + ", instance=" + instance + " schema=" + schema + ", driver=" + driver);
            assertNotNull(user);
            assertNotNull(password);
            assertNotNull(server);
            assertNotNull(portStr);
            assertFalse(port==0);
            assertNotNull(instance);
            assertNotNull(schema);
            assertNotNull(driver);   
            assertNotNull(qName);
    }
    /**
     * Tries to make a database connection to Oracle using the properties in the
     * oracle-aq.properties file.
     *
     */
    @Test
    public void createDsConnection()
    {
        DataSource ds = null;
        System.out.println("Building our db connection");
        Connection connection=null;
        try {
            ds = AQUtil.getSQLDataSource(server, instance, port, driver, user, password);
            connection = ds.getConnection();
            CallableStatement statement = connection.prepareCall("Select * from DUAL");
            statement.execute();
        } catch (Throwable e) {
            e.printStackTrace();
            assertTrue(false);
        } finally {
            if (connection!=null) {
                try { connection.close();
                } catch (Exception e) {}
            }
        }
    }
    
    @Before
    public void readProperyFile() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("src/test/resources/oracle-aq.properties"));
            if (properties.containsKey(AQInitialContextFactory.DB_DATASOURCE)) {
                String datasourceName = properties.getProperty(AQInitialContextFactory.DB_DATASOURCE);
                System.out.println("Found datasource name: " + datasourceName);
                System.err.println("We can't use a Datasource in JUnit.");
                assertTrue(false);
            } else {
                user     = properties.getProperty(AQInitialContextFactory.DB_USER);
                password = properties.getProperty(AQInitialContextFactory.DB_PASSWD);
                server   = properties.getProperty(AQInitialContextFactory.DB_SERVER);
                instance = properties.getProperty(AQInitialContextFactory.DB_INSTANCE);
                schema   = properties.getProperty(AQInitialContextFactory.DB_SCHEMA);
                driver   = properties.getProperty(AQInitialContextFactory.DB_DRIVER);
                portStr  = properties.getProperty(AQInitialContextFactory.DB_PORT);
                port     = Integer.valueOf(portStr);
                qName    = properties.getProperty(Q_NAME);
            }
        } catch (Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }
    
    
}
