package org.drools.brms.gwtutil;
/*
 * Copyright 2005 JBoss Inc
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



import java.lang.reflect.Method;

import org.drools.brms.client.rpc.RepositoryService;

/**
 * This utility uses reflection to generate the async interface from the 
 * Service interface as per GWT standard.
 * 
 * @author Michael Neale
 */
public class AsyncInterfaceGenerator {

    public static void main(String[] args) throws Exception {
        Class cls = RepositoryService.class;
        String line = "";
        Method[] methods = cls.getMethods();
        for ( int i = 0; i < methods.length; i++ ) {
            Method meth = methods[i];
            if (meth.getDeclaringClass() == cls) {
                line += "public void " + meth.getName() + "(";
                Class params[] = meth.getParameterTypes();
                for ( int j = 0; j < params.length; j++ ) {
                    String type = params[j].getName();
                    if (type.equals( "[Ljava.lang.String;" )) {
                        type = "String[]";
                    }
                    line += type;
                    line += " p" + j;
                    if (j < params.length -1) {
                        line += ", ";
                    }
                }
                if (line.endsWith( "(" )) {
                    line += "AsyncCallback cb";
                } else {
                    line += ", AsyncCallback cb";
                }
                line += ");\n";
            }
        }
        System.out.println("/** Generated by AsyncInterfaceGenerator hackery */");
        System.out.println(line);
    }

}