/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wspolicy;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.WSException;
import org.jboss.ws.wspolicy.Policy;
import org.jboss.ws.wspolicy.PolicyAlternative;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PolicyFactory {
    private static PolicyFactory factory = new PolicyFactory();

    private PolicyFactory() {
    }

    public static PolicyFactory newInstance() {
        return factory;
    }

    public Policy createPolicy(String strPolicy) {
        try {
            return this.createPolicy(DOMUtils.parse((String)strPolicy));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot parse: " + strPolicy, ex);
        }
    }

    public Policy createPolicy(Element elPolicy) {
        elPolicy = (Element)elPolicy.cloneNode(true);
        Policy policy = new Policy();
        policy.setTargetNamespace(DOMUtils.getAttributeValue((Element)elPolicy, (String)"TargetNamespace"));
        policy.setBaseURI(DOMUtils.getAttributeValue((Element)elPolicy, (String)"xml:base"));
        policy.setID(DOMUtils.getAttributeValue((Element)elPolicy, (QName)new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")));
        NamedNodeMap attribs = elPolicy.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            if (!attrName.startsWith("xmlns:")) continue;
            String prefix = attrName.substring(6);
            policy.getNamespaceRegistry().registerURI(attrValue, prefix);
        }
        QName oneQName = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "ExactlyOne");
        Element elExactlyOne = DOMUtils.getFirstChildElement((Node)elPolicy, (QName)oneQName);
        if (elExactlyOne == null) {
            throw new WSException("Cannot find child element: " + oneQName);
        }
        QName allQName = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "All");
        Element elAll = DOMUtils.getFirstChildElement((Node)elExactlyOne, (QName)allQName);
        if (elAll == null) {
            throw new WSException("Cannot find child element: " + allQName);
        }
        Iterator it = DOMUtils.getChildElements((Node)elExactlyOne, (QName)allQName);
        while (it.hasNext()) {
            elAll = (Element)it.next();
            PolicyAlternative all = PolicyAlternative.parse(elAll);
            policy.addPolicyAlternative(all);
        }
        return policy;
    }
}

