/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.jaxrpc.encoding.SerializerSupport;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.NamedNodeMap;

public class QNameSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(QNameSerializer.class);

    public String serialize(QName xmlName, QName xmlType, Object value, SerializationContextImpl serContext, NamedNodeMap attributes) throws BindingException {
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        QName qnameValue = (QName)value;
        String nsURI = qnameValue.getNamespaceURI();
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        if (nsURI.length() > 0) {
            qnameValue = new QName(qnameValue.getNamespaceURI(), qnameValue.getLocalPart());
            qnameValue = nsRegistry.registerQName(qnameValue);
        }
        String valueStr = SimpleTypeBindings.marshalQName((QName)qnameValue, (NamespaceContext)nsRegistry);
        String xmlFragment = this.wrapValueStr(xmlName, valueStr, nsRegistry, attributes);
        if (nsURI.length() > 0) {
            StringBuilder buffer = new StringBuilder(xmlFragment);
            int indexGT = xmlFragment.indexOf(">");
            String prefix = qnameValue.getPrefix();
            buffer.insert(indexGT, " xmlns:" + prefix + "='" + nsURI + "'");
            xmlFragment = buffer.toString();
        }
        return xmlFragment;
    }
}

