/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdres.trans;

import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.w3c.dom.Element;

public class RenameAttributeTU
implements DOMElementVisitor {
    private String attributeName;
    private String attributeNewName;
    private boolean overwrite;
    private boolean visitBefore;

    public void setConfiguration(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException {
        this.attributeName = resourceConfig.getStringParameter("attributeName");
        if (this.attributeName == null) {
            throw new IllegalStateException(RenameAttributeTU.class + " cdres must define a 'attributeName' param.");
        }
        this.attributeNewName = resourceConfig.getStringParameter("attributeNewName");
        if (this.attributeNewName == null) {
            throw new IllegalStateException(RenameAttributeTU.class + " cdres must define a 'attributeNewName' param.");
        }
        this.overwrite = resourceConfig.getBoolParameter("overwrite", false);
        this.visitBefore = resourceConfig.getBoolParameter("visitBefore", false);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        if (this.visitBefore) {
            this.visit(element, executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) {
        if (!this.visitBefore) {
            this.visit(element, executionContext);
        }
    }

    private void visit(Element element, ExecutionContext executionContext) {
        if (!this.overwrite && element.hasAttribute(this.attributeNewName)) {
            return;
        }
        String attributeValue = element.getAttribute(this.attributeName);
        if (attributeValue != null) {
            element.removeAttribute(this.attributeName);
            element.setAttribute(this.attributeNewName, attributeValue);
        }
    }
}

