/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.IfInvalid;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Interceptor(stateless=true, within={BijectionInterceptor.class})
public class ValidationInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 4724500409653141512L;
    private static final LogProvider log = Logging.getLogProvider(ValidationInterceptor.class);

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Method method = invocation.getMethod();
        if (method.isAnnotationPresent(IfInvalid.class)) {
            IfInvalid ifInvalid = method.getAnnotation(IfInvalid.class);
            InvalidValue[] invalidValues = this.getComponent().getValidator().getInvalidValues(invocation.getTarget());
            if (invalidValues.length == 0) {
                return invocation.proceed();
            }
            log.debug("invalid component state: " + this.getComponent().getName());
            for (InvalidValue iv : invalidValues) {
                log.debug("invalid value: " + iv);
                if (ifInvalid.refreshEntities() && iv.getBeanClass().isAnnotationPresent(Entity.class)) {
                    this.refreshInvalidEntity(ifInvalid, iv.getBean());
                }
                FacesMessages.instance().addToControl(iv);
            }
            String outcome = ifInvalid.outcome();
            return "org.jboss.seam.outcome.null".equals(outcome) ? null : outcome;
        }
        return invocation.proceed();
    }

    private void refreshInvalidEntity(IfInvalid ifInvalid, Object entity) {
        Object persistenceContext = Component.getInstance(ifInvalid.persistenceContext(), false);
        if (persistenceContext == null) {
            throw new IllegalStateException("Seam-managed persistence context not found: " + ifInvalid.persistenceContext());
        }
        if (persistenceContext instanceof EntityManager) {
            EntityManager em = (EntityManager)persistenceContext;
            if (em.contains(entity)) {
                em.refresh(entity);
            }
        } else {
            Session session = (Session)persistenceContext;
            if (session.contains(entity)) {
                session.refresh(entity);
            }
        }
    }
}

