/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.annotations.RaiseEvent;
import org.jboss.seam.core.Events;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.BusinessProcessInterceptor;
import org.jboss.seam.interceptors.ConversationInterceptor;
import org.jboss.seam.interceptors.RollbackInterceptor;
import org.jboss.seam.interceptors.TransactionInterceptor;

@Interceptor(stateless=true, around={BijectionInterceptor.class, ConversationInterceptor.class, TransactionInterceptor.class, BusinessProcessInterceptor.class, RollbackInterceptor.class})
public class EventInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -136300200838134612L;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        Object result = ctx.proceed();
        Method method = ctx.getMethod();
        if ((result != null || method.getReturnType().equals(Void.TYPE)) && method.isAnnotationPresent(RaiseEvent.class)) {
            String type = method.getAnnotation(RaiseEvent.class).value();
            if ("".equals(type)) {
                type = method.getName();
            }
            Events.instance().raiseEvent(type, new Object[0]);
        }
        return result;
    }
}

