/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import org.jboss.seam.Component;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Interceptor
public class BijectionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 4686458105931528659L;
    private static final LogProvider log = Logging.getLogProvider(BijectionInterceptor.class);
    private boolean reentrant;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        if (this.reentrant) {
            if (log.isTraceEnabled()) {
                log.trace("reentrant call to component: " + this.getComponent().getName());
            }
            return invocation.proceed();
        }
        this.reentrant = true;
        try {
            Component component = this.getComponent();
            boolean enforceRequired = !component.isLifecycleMethod(invocation.getMethod());
            component.inject(invocation.getTarget(), enforceRequired);
            Object result = invocation.proceed();
            component.outject(invocation.getTarget(), enforceRequired);
            component.disinject(invocation.getTarget());
            Object object = result;
            return object;
        }
        finally {
            this.reentrant = false;
        }
    }
}

