/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import javax.ejb.Timer;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Asynchronous;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Dispatcher;
import org.jboss.seam.core.LocalDispatcher;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;

@Interceptor(stateless=true, type=InterceptorType.CLIENT)
public class AsynchronousInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 9194177339867853303L;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        boolean scheduleAsync;
        boolean bl = scheduleAsync = invocation.getMethod().isAnnotationPresent(Asynchronous.class) && !Contexts.getEventContext().isSet("org.jboss.seam.core.executingAsynchronousCall");
        if (scheduleAsync) {
            LocalDispatcher dispatcher = Dispatcher.instance();
            if (dispatcher == null) {
                throw new IllegalStateException("org.jboss.seam.core.dispatcher is not installed in components.xml");
            }
            Timer timer = dispatcher.scheduleInvocation(invocation, this.getComponent());
            return invocation.getMethod().getReturnType().equals(Timer.class) ? timer : null;
        }
        return invocation.proceed();
    }
}

