/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.ejb.SeamInterceptor;
import org.jboss.seam.intercept.EventType;
import org.jboss.seam.intercept.RootInterceptor;
import org.jboss.seam.intercept.RootInvocationContext;
import org.jboss.seam.intercept.SessionBeanInterceptor;

public class ClientSideInterceptor
extends RootInterceptor
implements MethodInterceptor {
    private static final long serialVersionUID = -1578313703571846699L;
    private final Object bean;
    private final Class beanClass;

    public ClientSideInterceptor(Object bean, Component component) {
        super(InterceptorType.CLIENT);
        this.bean = bean;
        this.beanClass = component.getBeanClass();
        this.init(component);
    }

    public Object intercept(Object proxy, Method method, Object[] params, MethodProxy methodProxy) throws Throwable {
        Object result;
        String methodName = method.getName();
        if (params != null && params.length == 0) {
            if ("finalize".equals(methodName)) {
                return methodProxy.invokeSuper(proxy, params);
            }
            if ("writeReplace".equals(methodName)) {
                return this;
            }
        }
        return this.sessionBeanReturnedThis(result = this.invoke(this.createInvocationContext(method, params, methodProxy), EventType.AROUND_INVOKE)) ? proxy : result;
    }

    private boolean sessionBeanReturnedThis(Object result) {
        return result == this.bean || result != null && this.getComponent().getBeanClass().isAssignableFrom(result.getClass());
    }

    private RootInvocationContext createInvocationContext(Method method, Object[] params, MethodProxy methodProxy) {
        return new RootInvocationContext(this.bean, method, params, methodProxy){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object proceed() throws Exception {
                Component old = SessionBeanInterceptor.COMPONENT.get();
                SeamInterceptor.COMPONENT.set(ClientSideInterceptor.this.getComponent());
                try {
                    Object object = super.proceed();
                    return object;
                }
                finally {
                    SeamInterceptor.COMPONENT.set(old);
                }
            }
        };
    }

    Object readResolve() {
        Component comp = null;
        try {
            comp = this.getComponent();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            if (comp == null) {
                Factory proxy = Component.createProxyFactory(ComponentType.STATEFUL_SESSION_BEAN, this.beanClass, Component.getBusinessInterfaces(this.beanClass)).newInstance();
                proxy.setCallback(0, (Callback)this);
                return proxy;
            }
            return comp.wrap(this.bean, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

