/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.security.Principal;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.userPrincipal")
@Install(precedence=0)
public class UserPrincipal {
    @Unwrap
    public Principal getUserPrincipal() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return facesContext.getExternalContext().getUserPrincipal();
        }
        ServletRequest servletRequest = Lifecycle.getServletRequest();
        if (servletRequest != null) {
            return ((HttpServletRequest)servletRequest).getUserPrincipal();
        }
        return null;
    }

    public static Principal instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        return (Principal)Component.getInstance(UserPrincipal.class, ScopeType.APPLICATION);
    }
}

