/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.hibernate.lob.ReaderInputStream;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.jbpm.SeamVariableResolver;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.pageflow.PageflowHelper;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Resources;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.xml.sax.InputSource;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Startup(depends={"org.jboss.seam.core.microcontainer", "org.jboss.seam.core.ejb"})
@Name(value="org.jboss.seam.core.jbpm")
@Install(value=false, precedence=0)
public class Jbpm {
    private static final LogProvider log = Logging.getLogProvider(Jbpm.class);
    private JbpmConfiguration jbpmConfiguration;
    private String jbpmConfigurationJndiName;
    private String[] processDefinitions;
    private String[] pageflowDefinitions;
    private Map<String, ProcessDefinition> pageflowProcessDefinitions = new HashMap<String, ProcessDefinition>();

    @Create
    public void startup() throws Exception {
        log.trace("Starting jBPM");
        this.installProcessDefinitions();
        this.installPageflowDefinitions();
        JbpmExpressionEvaluator.setVariableResolver((VariableResolver)new SeamVariableResolver());
    }

    @Destroy
    public void shutdown() {
        if (this.jbpmConfiguration != null) {
            this.jbpmConfiguration.close();
        }
    }

    public JbpmConfiguration getJbpmConfiguration() {
        if (this.jbpmConfiguration == null) {
            this.initJbpmConfiguration();
        }
        return this.jbpmConfiguration;
    }

    private void initJbpmConfiguration() {
        if (this.jbpmConfigurationJndiName == null) {
            this.jbpmConfiguration = JbpmConfiguration.getInstance();
        } else {
            try {
                this.jbpmConfiguration = (JbpmConfiguration)Naming.getInitialContext().lookup(this.jbpmConfigurationJndiName);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("JbpmConfiguration not found in JNDI", ne);
            }
        }
        DbPersistenceServiceFactory dbpsf = (DbPersistenceServiceFactory)this.jbpmConfiguration.getServiceFactory("persistence");
        if (Naming.getInitialContextProperties() != null) {
            Hashtable hash = Naming.getInitialContextProperties();
            Properties prefixed = new Properties();
            for (Map.Entry entry : hash.entrySet()) {
                prefixed.setProperty("hibernate.jndi." + (String)entry.getKey(), (String)entry.getValue());
            }
            dbpsf.getConfiguration().getProperties().putAll((Map<?, ?>)prefixed);
        }
    }

    public ProcessDefinition getPageflowProcessDefinition(String pageflowName) {
        return this.pageflowProcessDefinitions.get(pageflowName);
    }

    public ProcessDefinition getPageflowDefinitionFromResource(String resourceName) {
        InputStream resource = Resources.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("pageflow resource not found: " + resourceName);
        }
        return PageflowHelper.parseInputSource(new InputSource(resource));
    }

    public ProcessDefinition getProcessDefinitionFromResource(String resourceName) {
        InputStream resource = Resources.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("process definition resource not found: " + resourceName);
        }
        return ProcessDefinition.parseXmlInputStream((InputStream)resource);
    }

    public String[] getPageflowDefinitions() {
        return this.pageflowDefinitions;
    }

    public void setPageflowDefinitions(String[] pageflowDefinitions) {
        this.pageflowDefinitions = pageflowDefinitions;
    }

    public String[] getProcessDefinitions() {
        return this.processDefinitions;
    }

    public void setProcessDefinitions(String[] processDefinitions) {
        this.processDefinitions = processDefinitions;
    }

    public boolean deployPageflowDefinition(ProcessDefinition pageflowDefinition) {
        return this.pageflowProcessDefinitions.put(pageflowDefinition.getName(), pageflowDefinition) != null;
    }

    public ProcessDefinition getPageflowDefinitionFromXml(String pageflowDefinition) {
        return PageflowHelper.parseInputSource(new InputSource((InputStream)new ReaderInputStream((Reader)new StringReader(pageflowDefinition))));
    }

    public ProcessDefinition getProcessDefinitionFromXml(String processDefinition) {
        return ProcessDefinition.parseXmlInputStream((InputStream)new ReaderInputStream((Reader)new StringReader(processDefinition)));
    }

    public boolean undeployPageflowDefinition(String pageflowName) {
        return this.pageflowProcessDefinitions.remove(pageflowName) != null;
    }

    private void installPageflowDefinitions() {
        if (this.pageflowDefinitions != null) {
            for (String pageflow : this.pageflowDefinitions) {
                ProcessDefinition pd = this.getPageflowDefinitionFromResource(pageflow);
                this.pageflowProcessDefinitions.put(pd.getName(), pd);
            }
        }
    }

    private void installProcessDefinitions() {
        if (this.processDefinitions != null && this.processDefinitions.length > 0) {
            JbpmContext jbpmContext = this.getJbpmConfiguration().createJbpmContext();
            try {
                for (String definitionResource : this.processDefinitions) {
                    ProcessDefinition processDefinition = ProcessDefinition.parseXmlResource((String)definitionResource);
                    if (log.isDebugEnabled()) {
                        log.debug("deploying process definition : " + processDefinition.getName());
                    }
                    jbpmContext.deployProcessDefinition(processDefinition);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException("could not deploy a process definition", e);
            }
            finally {
                jbpmContext.close();
            }
        }
    }

    public static Jbpm instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        if (!Init.instance().isJbpmInstalled()) {
            throw new IllegalStateException("jBPM support is not installed (use components.xml to install it)");
        }
        return (Jbpm)Contexts.getApplicationContext().get(Jbpm.class);
    }

    protected String getJbpmConfigurationJndiName() {
        return this.jbpmConfigurationJndiName;
    }

    protected void setJbpmConfigurationJndiName(String jbpmConfigurationJndiName) {
        this.jbpmConfigurationJndiName = jbpmConfigurationJndiName;
    }
}

