/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import org.jboss.seam.Component;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class Contexts {
    private static final LogProvider log = Logging.getLogProvider(Contexts.class);
    static final ThreadLocal<Context> applicationContext = new ThreadLocal();
    static final ThreadLocal<Context> methodContext = new ThreadLocal();
    static final ThreadLocal<Context> eventContext = new ThreadLocal();
    static final ThreadLocal<Context> pageContext = new ThreadLocal();
    static final ThreadLocal<Context> sessionContext = new ThreadLocal();
    static final ThreadLocal<Context> conversationContext = new ThreadLocal();
    static final ThreadLocal<Context> businessProcessContext = new ThreadLocal();

    public static Context getEventContext() {
        return eventContext.get();
    }

    public static Context getMethodContext() {
        return methodContext.get();
    }

    public static Context getPageContext() {
        return pageContext.get();
    }

    public static Context getSessionContext() {
        return sessionContext.get();
    }

    public static Context getApplicationContext() {
        return applicationContext.get();
    }

    public static Context getConversationContext() {
        return conversationContext.get();
    }

    public static Context getBusinessProcessContext() {
        return businessProcessContext.get();
    }

    public static boolean isConversationContextActive() {
        return Contexts.getConversationContext() != null;
    }

    public static boolean isEventContextActive() {
        return eventContext.get() != null;
    }

    public static boolean isMethodContextActive() {
        return methodContext.get() != null;
    }

    public static boolean isPageContextActive() {
        return pageContext.get() != null;
    }

    public static boolean isSessionContextActive() {
        return sessionContext.get() != null;
    }

    public static boolean isApplicationContextActive() {
        return applicationContext.get() != null;
    }

    public static boolean isBusinessProcessContextActive() {
        return businessProcessContext.get() != null;
    }

    public static void removeFromAllContexts(String name) {
        log.debug("removing from all contexts: " + name);
        if (Contexts.isMethodContextActive()) {
            Contexts.getMethodContext().remove(name);
        }
        if (Contexts.isEventContextActive()) {
            Contexts.getEventContext().remove(name);
        }
        if (Contexts.isPageContextActive()) {
            Contexts.getPageContext().remove(name);
        }
        if (Contexts.isConversationContextActive()) {
            Contexts.getConversationContext().remove(name);
        }
        if (Contexts.isSessionContextActive()) {
            Contexts.getSessionContext().remove(name);
        }
        if (Contexts.isBusinessProcessContextActive()) {
            Contexts.getBusinessProcessContext().remove(name);
        }
        if (Contexts.isApplicationContextActive()) {
            Contexts.getApplicationContext().remove(name);
        }
    }

    public static Object lookupInStatefulContexts(String name) {
        Object result;
        if (Contexts.isMethodContextActive() && (result = Contexts.getMethodContext().get(name)) != null) {
            log.debug("found in method context: " + name);
            return result;
        }
        if (Contexts.isEventContextActive() && (result = Contexts.getEventContext().get(name)) != null) {
            log.debug("found in event context: " + name);
            return result;
        }
        if (Contexts.isPageContextActive() && (result = Contexts.getPageContext().get(name)) != null) {
            log.debug("found in page context: " + name);
            return result;
        }
        if (Contexts.isConversationContextActive() && (result = Contexts.getConversationContext().get(name)) != null) {
            log.debug("found in conversation context: " + name);
            return result;
        }
        if (Contexts.isSessionContextActive() && (result = Contexts.getSessionContext().get(name)) != null) {
            log.debug("found in session context: " + name);
            return result;
        }
        if (Contexts.isBusinessProcessContextActive() && (result = Contexts.getBusinessProcessContext().get(name)) != null) {
            log.debug("found in business process context: " + name);
            return result;
        }
        if (Contexts.isApplicationContextActive() && (result = Contexts.getApplicationContext().get(name)) != null) {
            log.debug("found in application context: " + name);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(Context context) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preDestroyContext." + context.getType().toString(), new Object[0]);
        }
        Lifecycle.startDestroying();
        try {
            for (String name : context.getNames()) {
                Object object;
                Component component = Component.forName(name);
                log.debug("destroying: " + name);
                if (component == null || (object = context.get(name)) == null) continue;
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.preDestroy." + name, new Object[0]);
                }
                try {
                    component.callDestroyMethod(object);
                }
                catch (Exception e) {
                    log.warn("Could not destroy component: " + name, e);
                }
            }
        }
        finally {
            Lifecycle.stopDestroying();
        }
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postDestroyContext." + context.getType().toString(), new Object[0]);
        }
    }
}

