/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.Attributes;

public class SequenceBinding
extends ModelGroupBinding {
    private List sequence = Collections.EMPTY_LIST;
    private ElementBinding arrayItem;

    public SequenceBinding(SchemaBinding schema) {
        super(schema);
    }

    public ElementBinding getArrayItem() {
        return this.arrayItem;
    }

    public void addParticle(ParticleBinding particle) {
        switch (this.sequence.size()) {
            case 0: {
                this.sequence = Collections.singletonList(particle);
                if (!particle.isRepeatable() || !(particle.getTerm() instanceof ElementBinding)) break;
                ElementBinding element = (ElementBinding)particle.getTerm();
                if (!particle.isRepeatable()) break;
                this.arrayItem = element;
                break;
            }
            case 1: {
                this.sequence = new ArrayList(this.sequence);
                this.arrayItem = null;
            }
            default: {
                this.sequence.add(particle);
            }
        }
        super.addParticle(particle);
    }

    public Collection getParticles() {
        return Collections.unmodifiableCollection(this.sequence);
    }

    public ModelGroupBinding.Cursor newCursor(ParticleBinding particle) {
        return new ModelGroupBinding.Cursor(particle){
            private int pos;
            private ElementBinding element;
            private int occurence;
            {
                this.pos = -1;
            }

            public ParticleBinding getCurrentParticle() {
                if (this.pos < 0) {
                    throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
                }
                return (ParticleBinding)SequenceBinding.this.sequence.get(this.pos);
            }

            public ElementBinding getElement() {
                if (this.pos < 0) {
                    throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
                }
                return this.element;
            }

            public void endElement(QName qName) {
                if (this.element == null || !this.element.getQName().equals(qName)) {
                    throw new JBossXBRuntimeException("Failed to process endElement for " + qName + " since the current element is " + (this.element == null ? "null" : this.element.getQName().toString()));
                }
                if (ModelGroupBinding.log.isTraceEnabled()) {
                    ModelGroupBinding.log.trace("endElement " + qName + " in " + this.getModelGroup());
                }
            }

            public int getOccurence() {
                return this.occurence;
            }

            protected List startElement(QName qName, Attributes atts, Set passedGroups, List groupStack, boolean required) {
                ParticleBinding particle;
                if (ModelGroupBinding.log.isTraceEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("startElement " + qName + " in " + this.getModelGroup() + ", " + SequenceBinding.this.sequence.size() + ": ");
                    for (int i = 0; i < SequenceBinding.this.sequence.size(); ++i) {
                        ParticleBinding particle2 = (ParticleBinding)SequenceBinding.this.sequence.get(i);
                        TermBinding o = particle2.getTerm();
                        if (o instanceof ElementBinding) {
                            sb.append(((ElementBinding)o).getQName());
                        } else if (o instanceof SequenceBinding) {
                            sb.append("sequence");
                        } else if (o instanceof ChoiceBinding) {
                            sb.append("choice");
                        } else if (o instanceof AllBinding) {
                            sb.append("all");
                        }
                        sb.append(" ");
                    }
                    sb.append("]");
                    ModelGroupBinding.log.trace(sb.toString());
                }
                int i = this.pos;
                if (this.pos >= 0 && ((particle = this.getCurrentParticle()).getMaxOccursUnbounded() || this.occurence < particle.getMinOccurs() || this.occurence < particle.getMaxOccurs())) {
                    --i;
                }
                while (i < SequenceBinding.this.sequence.size() - 1) {
                    particle = (ParticleBinding)SequenceBinding.this.sequence.get(++i);
                    TermBinding item = particle.getTerm();
                    if (item instanceof ElementBinding) {
                        ElementBinding element = (ElementBinding)item;
                        if (qName.equals(element.getQName())) {
                            if (this.pos == i) {
                                ++this.occurence;
                            } else {
                                this.pos = i;
                                this.occurence = 1;
                            }
                            groupStack = this.addItem(groupStack, this);
                            this.element = element;
                            if (!ModelGroupBinding.log.isTraceEnabled()) break;
                            ModelGroupBinding.log.trace("found " + qName + " in " + this.getModelGroup());
                            break;
                        }
                        if (i == this.pos || particle.getMinOccurs() <= 0) continue;
                        if (!required) break;
                        throw new JBossXBRuntimeException("Requested element " + qName + " is not allowed in this position in the sequence. The next element should be " + element.getQName());
                    }
                    if (item instanceof ModelGroupBinding) {
                        ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                        if (!passedGroups.contains(modelGroup)) {
                            switch (passedGroups.size()) {
                                case 0: {
                                    passedGroups = Collections.singleton(this);
                                    break;
                                }
                                case 1: {
                                    passedGroups = new HashSet<1>(passedGroups);
                                }
                                default: {
                                    passedGroups.add(this);
                                }
                            }
                            int groupStackSize = groupStack.size();
                            groupStack = modelGroup.newCursor(particle).startElement(qName, atts, passedGroups, groupStack, particle.isRequired(this.occurence));
                            if (groupStackSize != groupStack.size()) {
                                if (this.pos != i) {
                                    this.pos = i;
                                    this.occurence = 1;
                                } else {
                                    ++this.occurence;
                                }
                                groupStack = this.addItem(groupStack, this);
                                this.element = null;
                                break;
                            }
                            if (i == this.pos || !particle.isRequired()) continue;
                            if (!required) break;
                            throw new JBossXBRuntimeException("Requested element " + qName + " is not allowed in this position in the sequence. A model group with minOccurs=" + particle.getMinOccurs() + " that doesn't contain this element must follow.");
                        }
                        if (i == this.pos || !particle.isRequired()) continue;
                        if (!required) break;
                        throw new JBossXBRuntimeException("Requested element " + qName + " is not allowed in this position in the sequence. A model group with minOccurs=" + particle.getMinOccurs() + " that doesn't contain this element must follow.");
                    }
                    if (!(item instanceof WildcardBinding)) continue;
                    WildcardBinding wildcard = (WildcardBinding)item;
                    this.element = wildcard.getElement(qName, atts);
                    if (this.element != null) {
                        if (this.pos != i) {
                            this.pos = i;
                            this.occurence = 1;
                        } else {
                            ++this.occurence;
                        }
                        groupStack = this.addItem(groupStack, this);
                        break;
                    }
                    if (i == this.pos || particle.getMinOccurs() <= 0) continue;
                    if (!required) break;
                    throw new JBossXBRuntimeException("Requested element " + qName + " is not allowed in this position in the sequence.");
                }
                if (ModelGroupBinding.log.isTraceEnabled() && i == SequenceBinding.this.sequence.size()) {
                    ModelGroupBinding.log.trace(qName + " not found in " + this.getModelGroup());
                }
                return groupStack;
            }

            protected ElementBinding getElement(QName qName, Attributes atts, Set passedGroups, boolean ignoreWildcards) {
                return this.getElement(SequenceBinding.this.sequence, qName, atts, passedGroups, ignoreWildcards);
            }
        };
    }

    protected boolean mayStartWith(QName qName, Set set) {
        boolean result = false;
        for (int i = 0; i < this.sequence.size(); ++i) {
            ParticleBinding particle = (ParticleBinding)this.sequence.get(i);
            TermBinding item = particle.getTerm();
            if (item instanceof ElementBinding) {
                ElementBinding element = (ElementBinding)item;
                if (qName.equals(element.getQName())) {
                    result = true;
                    break;
                }
                if (particle.getMinOccurs() <= 0) continue;
                break;
            }
            if (!(item instanceof ModelGroupBinding)) continue;
            ModelGroupBinding modelGroup = (ModelGroupBinding)item;
            if (!set.contains(modelGroup)) {
                switch (set.size()) {
                    case 0: {
                        set = Collections.singleton(this);
                        break;
                    }
                    case 1: {
                        set = new HashSet<SequenceBinding>(set);
                    }
                    default: {
                        set.add(this);
                    }
                }
                result = modelGroup.mayStartWith(qName, set);
                if (!result && particle.getMinOccurs() <= 0) continue;
                break;
            }
            if (particle.getMinOccurs() > 0) break;
        }
        return result;
    }
}

