/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.LogManager;
import javax.management.Attribute;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.Version;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.logging.JBossJDKLogManager;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.net.protocol.URLStreamHandlerFactory;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.NoAnnotationURLClassLoader;
import org.jboss.system.server.Server;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigImpl;
import org.jboss.system.server.ServerConfigImplMBean;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.system.server.jmx.LazyMBeanServer;
import org.jboss.util.StopWatch;
import org.jboss.util.UnexpectedThrowable;
import org.jboss.util.file.FileSuffixFilter;
import org.jboss.util.file.Files;

public class ServerImpl
implements Server,
ServerImplMBean,
NotificationEmitter {
    private static final ObjectName DEFAULT_LOADER_NAME = ObjectNameFactory.create("JMImplementation:service=LoaderRepository,name=Default");
    private Logger log;
    private final Version version = Version.getInstance();
    private final Package jbossPackage = Package.getPackage("org.jboss");
    private ServerConfigImpl config;
    private MBeanServer server;
    private Date startDate;
    private boolean started;
    private ShutdownHook shutdownHook;
    private LifeThread lifeThread;
    private JBossNotificationBroadcasterSupport broadcasterSupport;
    private ObjectName bootstrapUCLName;
    private boolean isInShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties props) throws IllegalStateException, Exception {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        if (this.config != null) {
            throw new IllegalStateException("already initialized");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.doInit(props);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private void doInit(Properties props) throws Exception {
        this.config = new ServerConfigImpl(props);
        this.config.getServerLogDir();
        this.log = Logger.getLogger(Server.class);
        this.broadcasterSupport = new JBossNotificationBroadcasterSupport();
        boolean overrideTmpDir = Boolean.getBoolean("jboss.server.temp.dir.overrideJavaTmpDir");
        if (overrideTmpDir) {
            File serverTmpDir = this.config.getServerTempDir();
            System.setProperty("java.io.tmpdir", serverTmpDir.getCanonicalPath());
        }
        this.initURLHandlers();
        this.config.initURLs();
        this.log.info("Starting JBoss (MX MicroKernel)...");
        if (this.jbossPackage != null) {
            this.log.info("Release ID: " + this.jbossPackage.getImplementationTitle() + " " + this.jbossPackage.getImplementationVersion());
        } else {
            this.log.warn("could not get package info to display release, either the jar manifest in jboss-system.jar has been mangled or you're running unit tests from ant outside of JBoss itself.");
        }
        this.log.debug("Using config: " + this.config);
        this.log.debug("Server type: " + this.getClass());
        ClassLoader cl = this.getClass().getClassLoader();
        this.log.debug("Server loaded through: " + cl.getClass().getName());
        if (cl instanceof NoAnnotationURLClassLoader) {
            NoAnnotationURLClassLoader nacl = (NoAnnotationURLClassLoader)cl;
            URL[] bootURLs = nacl.getAllURLs();
            this.log.debug("Boot URLs:");
            for (int i = 0; i < bootURLs.length; ++i) {
                this.log.debug("  " + bootURLs[i]);
            }
        }
        this.log.info("Home Dir: " + this.config.getHomeDir());
        this.log.info("Home URL: " + this.config.getHomeURL());
        this.log.debug("Library URL: " + this.config.getLibraryURL());
        this.log.info("Patch URL: " + this.config.getPatchURL());
        this.log.info("Server Name: " + this.config.getServerName());
        this.log.info("Server Home Dir: " + this.config.getServerHomeDir());
        this.log.info("Server Home URL: " + this.config.getServerHomeURL());
        this.log.debug("Server Data Dir: " + this.config.getServerDataDir());
        this.log.info("Server Temp Dir: " + this.config.getServerTempDir());
        this.log.debug("Server Config URL: " + this.config.getServerConfigURL());
        this.log.debug("Server Library URL: " + this.config.getServerLibraryURL());
        this.log.info("Root Deployment Filename: " + this.config.getRootDeploymentFilename());
    }

    private void initURLHandlers() {
        if (this.config.getRequireJBossURLStreamHandlerFactory()) {
            this.internalInitURLHandlers();
        } else {
            try {
                this.internalInitURLHandlers();
            }
            catch (SecurityException e) {
                this.log.warn("You do not have permissions to set URLStreamHandlerFactory", e);
            }
            catch (Error e) {
                this.log.warn("URLStreamHandlerFactory already set", e);
            }
        }
    }

    private void internalInitURLHandlers() {
        try {
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory());
            URLStreamHandlerFactory.preload();
        }
        catch (Error error) {
            this.log.warn("Caught Throwable Error, this probably means we've already set the URLStreamHAndlerFactory before");
        }
        String handlerPkgs = System.getProperty("java.protocol.handler.pkgs");
        handlerPkgs = handlerPkgs != null ? handlerPkgs + "|org.jboss.net.protocol" : "org.jboss.net.protocol";
        System.setProperty("java.protocol.handler.pkgs", handlerPkgs);
    }

    public ServerConfig getConfig() throws IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("not initialized");
        }
        return this.config;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isInShutdown() {
        return this.isInShutdown;
    }

    public void start() throws IllegalStateException, Exception {
        this.getConfig();
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                this.doStart();
            }
            catch (Exception e) {
                JMXExceptionDecoder.rethrow(e);
            }
        }
        catch (Throwable t) {
            this.log.debug("Failed to start", t);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new UnexpectedThrowable(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private void doStart() throws Exception {
        StopWatch watch = new StopWatch(true);
        this.startDate = new Date();
        this.log.debug("Starting General Purpose Architecture (GPA)...");
        String builder = System.getProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
        System.setProperty("javax.management.builder.initial", builder);
        if (this.config.getPlatformMBeanServer()) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass("java.lang.management.ManagementFactory");
            Method method = clazz.getMethod("getPlatformMBeanServer", null);
            this.server = (MBeanServer)method.invoke(null, null);
            MBeanServerLocator.setJBoss(this.server);
            this.server = LazyMBeanServer.resetToJBossServer(this.server);
        } else {
            this.server = MBeanServerFactory.createMBeanServer("jboss");
        }
        this.log.debug("Created MBeanServer: " + this.server);
        this.server.registerMBean(this, ServerImplMBean.OBJECT_NAME);
        this.server.registerMBean(this.config, ServerConfigImplMBean.OBJECT_NAME);
        RepositoryClassLoader ucl = this.initBootLibraries();
        this.bootstrapUCLName = ucl.getObjectName();
        this.server.registerMBean(ucl, this.bootstrapUCLName);
        Thread.currentThread().setContextClassLoader(ucl);
        this.createMBean("org.jboss.system.server.ServerInfo", "jboss.system:type=ServerInfo");
        ObjectName controller = this.createMBean("org.jboss.system.ServiceController", "jboss.system:service=ServiceController");
        ObjectName mainDeployer = this.startBootService(controller, "org.jboss.deployment.MainDeployer", "jboss.system:service=MainDeployer");
        this.server.setAttribute(mainDeployer, new Attribute("ServiceController", controller));
        this.shutdownHook = new ShutdownHook(controller, mainDeployer);
        this.shutdownHook.setDaemon(true);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.log.debug("Shutdown hook added");
        }
        catch (Exception e) {
            this.log.warn("Failed to add shutdown hook; ignoring", e);
        }
        this.startBootService(controller, "org.jboss.deployment.JARDeployer", "jboss.system:service=JARDeployer");
        this.startBootService(controller, "org.jboss.deployment.SARDeployer", "jboss.system:service=ServiceDeployer");
        this.log.info("Core system initialized");
        MainDeployerMBean md = (MainDeployerMBean)MBeanProxyExt.create(MainDeployerMBean.class, mainDeployer, this.server);
        try {
            md.deploy(this.config.getServerConfigURL() + this.config.getRootDeploymentFilename());
        }
        catch (IncompleteDeploymentException e) {
            this.log.error("Root deployment has missing dependencies; continuing", e);
        }
        this.lifeThread = new LifeThread();
        this.lifeThread.start();
        this.started = true;
        Notification msg = new Notification("org.jboss.system.server.started", this, 1L);
        msg.setUserData(new Long(watch.getLapTime()));
        this.sendNotification(msg);
        watch.stop();
        if (this.jbossPackage != null) {
            this.log.info("JBoss (MX MicroKernel) [" + this.jbossPackage.getImplementationVersion() + "] Started in " + watch);
        } else {
            this.log.warn("could not get package info to display release, either the jar manifest in jboss-boot.jar has been mangled or you're running unit tests from ant outside of JBoss itself.");
        }
    }

    private ObjectName createMBean(String classname, String name) throws Exception {
        ObjectName mbeanName = null;
        if (name != null) {
            mbeanName = new ObjectName(name);
        }
        try {
            URL xmbeanDD = new URL("resource:xmdesc/" + classname + "-xmbean.xml");
            Object resource = this.server.instantiate(classname);
            Object[] args = new Object[]{resource, xmbeanDD};
            String[] sig = new String[]{Object.class.getName(), URL.class.getName()};
            ObjectInstance instance = this.server.createMBean("org.jboss.mx.modelmbean.XMBean", mbeanName, this.bootstrapUCLName, args, sig);
            mbeanName = instance.getObjectName();
            this.log.debug("Created system XMBean: " + mbeanName);
        }
        catch (Exception e) {
            this.log.debug("Failed to create xmbean for: " + classname);
            mbeanName = this.server.createMBean(classname, mbeanName).getObjectName();
            this.log.debug("Created system MBean: " + mbeanName);
        }
        return mbeanName;
    }

    private ObjectName startBootService(ObjectName controllerName, String classname, String name) throws Exception {
        ObjectName mbeanName = this.createMBean(classname, name);
        Object[] args = new Object[]{mbeanName};
        String[] sig = new String[]{ObjectName.class.getName()};
        this.server.invoke(controllerName, "create", args, sig);
        this.server.invoke(controllerName, "start", args, sig);
        return mbeanName;
    }

    private RepositoryClassLoader initBootLibraries() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        URL patchURL = this.config.getPatchURL();
        if (patchURL != null) {
            if (patchURL.getProtocol().equals("file")) {
                File dir = new File(patchURL.getFile());
                if (dir.exists()) {
                    list.add(dir.toURL());
                    File[] jars = dir.listFiles(new FileSuffixFilter(new String[]{".jar", ".zip"}, true));
                    for (int j = 0; jars != null && j < jars.length; ++j) {
                        list.add(jars[j].getCanonicalFile().toURL());
                    }
                }
            } else {
                list.add(patchURL);
            }
        }
        list.add(this.config.getServerConfigURL());
        this.log.debug("Boot url list: " + list);
        RepositoryClassLoader loader = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            this.log.debug("Creating loader for URL: " + url);
            Object[] args = new Object[]{url, Boolean.TRUE};
            String[] sig = new String[]{"java.net.URL", "boolean"};
            loader = (RepositoryClassLoader)this.server.invoke(DEFAULT_LOADER_NAME, "newClassLoader", args, sig);
        }
        return loader;
    }

    public void shutdown() throws IllegalStateException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Shutdown caller:", new Throwable("Here"));
        }
        if (!this.started) {
            throw new IllegalStateException("Server not started");
        }
        this.isInShutdown = true;
        boolean exitOnShutdown = this.config.getExitOnShutdown();
        boolean blockingShutdown = this.config.getBlockingShutdown();
        this.log.info("Shutting down the server, blockingShutdown: " + blockingShutdown);
        if (exitOnShutdown) {
            this.exit(0);
        } else {
            this.lifeThread.interrupt();
            if (blockingShutdown) {
                this.shutdownHook.shutdown();
            } else {
                new Thread(){

                    public void run() {
                        ServerImpl.this.shutdownHook.shutdown();
                    }
                }.start();
            }
        }
    }

    public void exit(final int exitcode) {
        new Thread(){

            public void run() {
                ServerImpl.this.log.info("Server exit(" + exitcode + ") called");
                ServerImpl.this.shutdownHook.setHaltExitCode(exitcode);
                Runtime.getRuntime().exit(exitcode);
            }
        }.start();
    }

    public void exit() {
        this.exit(1);
    }

    public void halt(final int exitcode) {
        new Thread(){

            public void run() {
                System.err.println("Server halt(" + exitcode + ") called, halting the JVM now!");
                Runtime.getRuntime().halt(exitcode);
            }
        }.start();
    }

    public void halt() {
        this.halt(1);
    }

    private void logMemoryUsage(Runtime rt) {
        this.log.info("Total/free memory: " + rt.totalMemory() + "/" + rt.freeMemory());
    }

    public void runGarbageCollector() {
        Runtime rt = Runtime.getRuntime();
        this.logMemoryUsage(rt);
        rt.gc();
        this.log.info("Hinted to the JVM to run garbage collection");
        this.logMemoryUsage(rt);
    }

    public void runFinalization() {
        Runtime.getRuntime().runFinalization();
        this.log.info("Hinted to the JVM to run any pending object finalizations");
    }

    public void traceMethodCalls(Boolean flag) {
        Runtime.getRuntime().traceMethodCalls(flag);
    }

    public void traceInstructions(Boolean flag) {
        Runtime.getRuntime().traceInstructions(flag);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public String getVersionName() {
        return this.version.getName();
    }

    public String getBuildNumber() {
        return this.version.getBuildNumber();
    }

    public String getBuildJVM() {
        return this.version.getBuildJVM();
    }

    public String getBuildOS() {
        return this.version.getBuildOS();
    }

    public String getBuildID() {
        return this.version.getBuildID();
    }

    public String getBuildDate() {
        return this.version.getBuildDate();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcasterSupport.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.broadcasterSupport.getNotificationInfo();
    }

    public void sendNotification(Notification notification) {
        this.broadcasterSupport.sendNotification(notification);
    }

    private class ShutdownHook
    extends Thread {
        private ObjectName controller;
        private ObjectName mainDeployer;
        private boolean forceHalt;
        private int haltExitCode;
        private boolean shutdownCalled;

        public ShutdownHook(ObjectName controller, ObjectName mainDeployer) {
            super("JBoss Shutdown Hook");
            this.forceHalt = true;
            this.controller = controller;
            this.mainDeployer = mainDeployer;
            String value = System.getProperty("jboss.shutdown.forceHalt", null);
            if (value != null) {
                this.forceHalt = new Boolean(value);
            }
        }

        public void setHaltExitCode(int haltExitCode) {
            this.haltExitCode = haltExitCode;
        }

        public void run() {
            ServerImpl.this.log.info("Runtime shutdown hook called, forceHalt: " + this.forceHalt);
            this.shutdown();
            LogManager lm = LogManager.getLogManager();
            if (lm instanceof JBossJDKLogManager) {
                JBossJDKLogManager jbosslm = (JBossJDKLogManager)lm;
                jbosslm.doReset();
            }
            if (this.forceHalt) {
                System.out.println("Halting VM");
                Runtime.getRuntime().halt(this.haltExitCode);
            }
        }

        public void shutdown() {
            if (ServerImpl.this.log.isTraceEnabled()) {
                ServerImpl.this.log.trace("Shutdown caller:", new Throwable("Here"));
            }
            if (this.shutdownCalled) {
                return;
            }
            this.shutdownCalled = true;
            Notification msg = new Notification("org.jboss.system.server.stopped", this, 2L);
            ServerImpl.this.sendNotification(msg);
            ServerImpl.this.log.info("JBoss SHUTDOWN: Undeploying all packages");
            this.shutdownDeployments();
            ServerImpl.this.log.debug("Shutting down all services");
            this.shutdownServices();
            this.removeMBeans();
            ServerImpl.this.log.debug("Deleting server tmp/deploy directory");
            File tmp = ServerImpl.this.config.getServerTempDir();
            File tmpDeploy = new File(tmp, "deploy");
            Files.delete(tmpDeploy);
            ServerImpl.this.log.info("Shutdown complete");
            System.out.println("Shutdown complete");
        }

        protected void shutdownDeployments() {
            try {
                ServerImpl.this.server.invoke(this.mainDeployer, "shutdown", new Object[0], new String[0]);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode(e);
                ServerImpl.this.log.error("Failed to shutdown deployer", t);
            }
        }

        protected void shutdownServices() {
            try {
                ServerImpl.this.server.invoke(this.controller, "shutdown", new Object[0], new String[0]);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode(e);
                ServerImpl.this.log.error("Failed to shutdown services", t);
            }
        }

        protected void removeMBeans() {
            Throwable t;
            try {
                ServerImpl.this.server.unregisterMBean(ServiceControllerMBean.OBJECT_NAME);
                ServerImpl.this.server.unregisterMBean(ServerConfigImplMBean.OBJECT_NAME);
                ServerImpl.this.server.unregisterMBean(ServerImplMBean.OBJECT_NAME);
            }
            catch (Exception e) {
                t = JMXExceptionDecoder.decode(e);
                ServerImpl.this.log.error("Failed to unregister mbeans", t);
            }
            try {
                MBeanServer registeredServer = ServerImpl.this.server;
                if (ServerImpl.this.config.getPlatformMBeanServer()) {
                    registeredServer = LazyMBeanServer.getRegisteredMBeanServer(ServerImpl.this.server);
                }
                MBeanServerFactory.releaseMBeanServer(registeredServer);
            }
            catch (Exception e) {
                t = JMXExceptionDecoder.decode(e);
                ServerImpl.this.log.error("Failed to release mbean server", t);
            }
        }
    }

    private class LifeThread
    extends Thread {
        Object lock;

        LifeThread() {
            super("JBossLifeThread");
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ServerImpl.this.log.debug("LifeThread.run() exits!");
        }
    }
}

