/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthParam;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.module.ServerAuthModule;
import org.jboss.logging.Logger;
import org.jboss.security.GeneralizedAuthenticationManager;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.auth.message.GenericAuthParam;
import org.jboss.security.plugins.SubjectActions;

public class JASPISecurityManager
implements GeneralizedAuthenticationManager {
    protected String securityDomain;
    protected CallbackHandler handler;
    private Method setSecurityInfo;
    private ThreadLocal sharedStateLocal = new ThreadLocal();
    private List serverAuthModules = new ArrayList();
    protected Logger log;
    protected boolean trace;

    public JASPISecurityManager() {
        this("other", new SecurityAssociationHandler());
    }

    public JASPISecurityManager(String securityDomain, CallbackHandler handler) {
        this.securityDomain = securityDomain;
        this.handler = handler;
        String categoryName = this.getClass().getName() + '.' + securityDomain;
        this.log = Logger.getLogger(categoryName);
        this.trace = this.log.isTraceEnabled();
        Class[] sig = new Class[]{Principal.class, Object.class};
        try {
            this.setSecurityInfo = handler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            String msg = "Failed to find setSecurityInfo(Princpal, Object) method in handler";
            throw new UndeclaredThrowableException(e, msg);
        }
        this.log.debug("CallbackHandler: " + handler);
        this.configureServerAuthModules(handler);
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        boolean isValid = this.authenticate(principal, credential, activeSubject);
        if (this.trace) {
            this.log.trace("End isValid, " + isValid);
        }
        return isValid;
    }

    public Subject getActiveSubject() {
        return SecurityAssociation.getSubject();
    }

    public void cleanSubject(Subject subject, Map sharedState) throws AuthException {
        this.updateSharedState(sharedState);
        int len = this.serverAuthModules.size();
        for (int i = 0; i < len; ++i) {
            ServerAuthModule sam = (ServerAuthModule)this.serverAuthModules.get(i);
            sam.cleanSubject(subject, (Map)this.sharedStateLocal.get());
        }
    }

    public AuthStatus secureResponse(AuthParam authParam, Subject source, Map sharedState) throws AuthException {
        throw new IllegalStateException("NotImplemented Yet");
    }

    public AuthStatus validateRequest(AuthParam authParam, Subject source, Subject recipient, Map sharedState) throws AuthException {
        AuthStatus status = AuthStatus.FAIL;
        AuthException authException = null;
        if (authParam == null) {
            throw new IllegalArgumentException("Illegal Null Argument:authParam");
        }
        if (source == null) {
            source = new Subject();
        }
        CallbackHandler theHandler = this.populateCallbackHandler(sharedState);
        this.updateSharedState(sharedState);
        this.serverAuthModules.clear();
        this.configureServerAuthModules(theHandler);
        int len = this.serverAuthModules.size();
        try {
            for (int i = 0; i < len; ++i) {
                ServerAuthModule sam = (ServerAuthModule)this.serverAuthModules.get(i);
                while ((status = sam.validateRequest(authParam, source, recipient, (Map)((HashMap)this.sharedStateLocal.get()))).equals(AuthStatus.RETRY)) {
                }
                if (!status.equals(AuthStatus.FAIL)) {
                    continue;
                }
                break;
            }
        }
        catch (AuthException e) {
            authException = e;
            SubjectActions.setContextInfo("org.jboss.security.exception", (Object)authException);
            throw e;
        }
        if (status.equals(AuthStatus.PROCEED)) {
            SubjectActions.setContextInfo("org.jboss.security.exception", (Object)authException);
            SubjectActions.pushSubjectContext(null, null, source);
        }
        return status;
    }

    public void flushAuthenticationCache() {
    }

    public void flushAuthenticationCache(Principal user) {
    }

    protected boolean authenticate(Principal principal, Object credential, Subject theSubject) {
        boolean isValid = false;
        HashMap<String, Principal> sharedState = (HashMap<String, Principal>)this.sharedStateLocal.get();
        if (sharedState == null) {
            sharedState = new HashMap<String, Principal>();
        }
        sharedState.put("javax.security.auth.login.name", principal);
        sharedState.put("javax.security.auth.login.password", (Principal)credential);
        try {
            AuthStatus status = this.validateRequest(new GenericAuthParam(), theSubject, null, sharedState);
            if (status.equals(AuthStatus.PROCEED)) {
                isValid = true;
            }
        }
        catch (AuthException e) {
            // empty catch block
        }
        return isValid;
    }

    private JASPIAuthenticationInfo getAuthenticationInfo() {
        BaseAuthenticationInfo authInfo = this.getBaseAuthenticationInfo();
        if (authInfo == null) {
            throw new IllegalStateException("authInfo is null");
        }
        if (authInfo instanceof AuthenticationInfo) {
            return this.convertJaasConfigToJASPI(authInfo);
        }
        if (authInfo instanceof JASPIAuthenticationInfo) {
            return (JASPIAuthenticationInfo)authInfo;
        }
        throw new IllegalStateException("AuthenticationInfo for securityDomain=" + this.securityDomain + " not found");
    }

    private BaseAuthenticationInfo getBaseAuthenticationInfo() {
        Configuration config = Configuration.getConfiguration();
        if (!(config instanceof XMLLoginConfigImpl)) {
            throw new IllegalStateException("Configuration not an instanceof XMLLoginConfigImpl");
        }
        XMLLoginConfigImpl xmlConfig = (XMLLoginConfigImpl)config;
        BaseAuthenticationInfo bai = xmlConfig.getAuthenticationInfo(this.securityDomain);
        if (bai == null) {
            String defaultDomain = "other";
            if (this.trace) {
                this.log.trace("App Config for securityDomain=" + this.securityDomain + "not found. Defaulting to securityDomain=" + defaultDomain);
            }
            bai = xmlConfig.getAuthenticationInfo(defaultDomain);
        }
        return bai;
    }

    private JASPIAuthenticationInfo convertJaasConfigToJASPI(BaseAuthenticationInfo authInfo) {
        if (!(authInfo instanceof AuthenticationInfo)) {
            throw new IllegalArgumentException("authInfo not an instance of Jaas AuthenticationInfo");
        }
        AuthenticationInfo aInfo = (AuthenticationInfo)authInfo;
        LoginModuleStackHolder lmsh = new LoginModuleStackHolder(this.securityDomain, Arrays.asList(aInfo.getAppConfigurationEntry()));
        AuthModuleEntry authEntry = new AuthModuleEntry("org.jboss.security.auth.container.modules.DelegatingServerAuthModule", null, null);
        authEntry.setLoginModuleStackHolder(lmsh);
        JASPIAuthenticationInfo jaspi = new JASPIAuthenticationInfo(this.securityDomain);
        jaspi.add(authEntry);
        return jaspi;
    }

    private ServerAuthModule getServerAuthModule(AuthModuleEntry entry, CallbackHandler theHandler) throws AuthException {
        String errorMsg = "Cannot instantiate " + entry.getAuthModuleName() + "::";
        ServerAuthModule sam = null;
        Class<?> authClass = null;
        try {
            authClass = SubjectActions.getContextClassLoader().loadClass(entry.getAuthModuleName());
            if (entry.getAuthModuleName().equals("org.jboss.security.auth.container.modules.DelegatingServerAuthModule")) {
                Constructor<?> ctr = authClass.getConstructor(LoginModuleStackHolder.class);
                sam = (ServerAuthModule)ctr.newInstance(entry.getLoginModuleStackHolder());
            } else {
                sam = (ServerAuthModule)authClass.newInstance();
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException(errorMsg + e.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new IllegalStateException(errorMsg + e.getLocalizedMessage());
        }
        Map options = entry.getOptions();
        sam.initialize(null, null, theHandler, options);
        return sam;
    }

    private void configureServerAuthModules(CallbackHandler theHandler) {
        JASPIAuthenticationInfo jAuthInfo = this.getAuthenticationInfo();
        AuthModuleEntry[] entries = jAuthInfo.getAuthModuleEntry();
        int lenOfEntries = entries != null ? entries.length : 0;
        for (int i = 0; i < lenOfEntries; ++i) {
            AuthModuleEntry entry = entries[i];
            try {
                this.serverAuthModules.add(this.getServerAuthModule(entry, theHandler));
                continue;
            }
            catch (AuthException ae) {
                this.log.error("Configuration of server auth modules failed::" + ae.getLocalizedMessage());
            }
        }
    }

    private void updateSharedState(Map sharedState) {
        HashMap _sharedStateMap = (HashMap)this.sharedStateLocal.get();
        if (sharedState != null) {
            if (_sharedStateMap == null) {
                _sharedStateMap = new HashMap(sharedState);
            } else {
                _sharedStateMap.putAll(sharedState);
            }
            this.sharedStateLocal.set(_sharedStateMap);
        }
    }

    private CallbackHandler populateCallbackHandler(Map sharedState) {
        CallbackHandler theHandler = this.handler;
        if (sharedState != null) {
            Principal principal = (Principal)sharedState.get("javax.security.auth.login.name");
            Object credential = sharedState.get("javax.security.auth.login.password");
            Object[] securityInfo = new Object[]{principal, credential};
            try {
                theHandler = (CallbackHandler)this.handler.getClass().newInstance();
                this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
            }
            catch (Throwable e) {
                if (this.trace) {
                    this.log.trace("Failed to create/setSecurityInfo on handler", e);
                }
                throw new IllegalStateException("Failed to setSecurityInfo on handler");
            }
        }
        return theHandler;
    }
}

