/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.oneway;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

public class OnewayClient {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;

    public void makeInvocation(String locatorURI) throws Throwable {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Calling remoting server with locator uri of: " + locatorURI);
        Client remotingClient = new Client(locator);
        String payload1 = "Oneway call 1.";
        System.out.println("Making oneway invocation with payload of '" + payload1 + "'");
        remotingClient.invokeOneway(payload1);
        String payload2 = "Oneway call 2.";
        System.out.println("Making oneway invocation with payload of '" + payload2 + "'");
        remotingClient.invokeOneway(payload2, null, true);
    }

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
        }
        String locatorURI = transport + "://" + host + ":" + port;
        OnewayClient client = new OnewayClient();
        try {
            client.makeInvocation(locatorURI);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

