/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.jboss.naming.Util;
import org.w3c.dom.Element;

public class EnvEntryMetaData
extends MetaData {
    private String name;
    private String type;
    private String value;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        this.name = EnvEntryMetaData.getElementContent(EnvEntryMetaData.getUniqueChild(element, "env-entry-name"));
        this.type = EnvEntryMetaData.getElementContent(EnvEntryMetaData.getUniqueChild(element, "env-entry-type"));
        this.type = this.type.trim();
        this.value = EnvEntryMetaData.getElementContent(EnvEntryMetaData.getUniqueChild(element, "env-entry-value"));
    }

    public static void bindEnvEntry(Context ctx, EnvEntryMetaData entry) throws ClassNotFoundException, NamingException {
        ClassLoader loader = EnvEntryMetaData.class.getClassLoader();
        Class<?> type = loader.loadClass(entry.getType());
        if (type == String.class) {
            Util.bind(ctx, entry.getName(), (Object)entry.getValue());
        } else if (type == Integer.class) {
            Util.bind(ctx, entry.getName(), (Object)new Integer(entry.getValue()));
        } else if (type == Long.class) {
            Util.bind(ctx, entry.getName(), (Object)new Long(entry.getValue()));
        } else if (type == Double.class) {
            Util.bind(ctx, entry.getName(), (Object)new Double(entry.getValue()));
        } else if (type == Float.class) {
            Util.bind(ctx, entry.getName(), (Object)new Float(entry.getValue()));
        } else if (type == Byte.class) {
            Util.bind(ctx, entry.getName(), (Object)new Byte(entry.getValue()));
        } else if (type == Character.class) {
            Character value = null;
            String input = entry.getValue();
            if (input == null || input.length() == 0) {
                value = new Character('\u0000');
            } else {
                if (input.length() > 1) {
                    log.warn("Warning character env-entry is too long: binding=" + entry.getName() + " value=" + input);
                }
                value = new Character(input.charAt(0));
            }
            Util.bind(ctx, entry.getName(), (Object)value);
        } else if (type == Short.class) {
            Util.bind(ctx, entry.getName(), (Object)new Short(entry.getValue()));
        } else if (type == Boolean.class) {
            Util.bind(ctx, entry.getName(), (Object)new Boolean(entry.getValue()));
        } else {
            Util.bind(ctx, entry.getName(), (Object)entry.getValue());
        }
    }
}

