/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.annotation.ejb.Depends;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.injection.DependsFieldInjector;
import org.jboss.ejb3.injection.DependsMethodInjector;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependsHandler {
    private static final Logger log = Logger.getLogger(DependsHandler.class);

    public static void loadDependencies(EJBContainer container, Class clazz) {
        HashSet<String> visitedMethods = new HashSet<String>();
        DependsHandler.loadClassDepends(container, clazz);
        DependsHandler.loadMethodDepends(visitedMethods, clazz, container);
        DependsHandler.loadFieldDepends(clazz, container);
    }

    public static void loadClassDepends(EJBContainer container, Class clazz) {
        Depends dep = (Depends)container.resolveAnnotation(Depends.class);
        if (dep == null) {
            return;
        }
        for (String dependency : dep.value()) {
            container.getDependencyPolicy().addDependency(dependency);
        }
    }

    private static void loadMethodDepends(HashSet<String> visitedMethods, Class clazz, EJBContainer container) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Depends dep = (Depends)container.resolveAnnotation(methods[i], Depends.class);
            if (dep == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            if (!methods[i].getName().startsWith("set")) {
                throw new RuntimeException("@Depends can only be used with a set method: " + methods[i]);
            }
            if (methods[i].getParameterTypes().length != 1) {
                throw new RuntimeException("@Depends annotated setter methods can only take one parameter: " + methods[i]);
            }
            String[] names = dep.value();
            if (names.length != 1) {
                throw new RuntimeException("@Depends on a method can only take one object name: " + methods[i]);
            }
            container.getDependencyPolicy().addDependency(names[0]);
        }
        DependsHandler.loadMethodDepends(visitedMethods, clazz.getSuperclass(), container);
    }

    private static void loadFieldDepends(Class clazz, EJBContainer container) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        DependsHandler.loadFieldDepends(clazz.getSuperclass(), container);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Depends dep = (Depends)container.resolveAnnotation(fields[i], Depends.class);
            if (dep == null) continue;
            String[] names = dep.value();
            if (names.length != 1) {
                throw new RuntimeException("@Depends on a field can only take one object name: " + fields[i]);
            }
            container.getDependencyPolicy().addDependency(names[0]);
        }
    }

    public static List loadInjectors(Container container) throws Exception {
        Class clazz = container.getBeanClass();
        HashSet<String> visitedMethods = new HashSet<String>();
        ArrayList list = new ArrayList();
        DependsHandler.loadMethodInjectors(visitedMethods, clazz, container, list);
        DependsHandler.loadFieldInjectors(clazz, container, list);
        return list;
    }

    private static void loadMethodInjectors(HashSet<String> visitedMethods, Class clazz, Container container, ArrayList list) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Depends dep = (Depends)((Advisor)((Object)container)).resolveAnnotation(methods[i], Depends.class);
            if (dep == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            if (!methods[i].getName().startsWith("set")) {
                throw new RuntimeException("@Depends can only be used with a set method: " + methods[i]);
            }
            if (methods[i].getParameterTypes().length != 1) {
                throw new RuntimeException("@Depends annotated setter methods can only take one parameter: " + methods[i]);
            }
            String[] names = dep.value();
            if (names.length != 1) {
                throw new RuntimeException("@Depends on a method can only take one object name: " + methods[i]);
            }
            ObjectName on = new ObjectName(names[0]);
            list.add(new DependsMethodInjector(methods[i], on));
        }
        if (clazz != null && !clazz.equals(Object.class)) {
            DependsHandler.loadMethodInjectors(visitedMethods, clazz.getSuperclass(), container, list);
        }
    }

    private static void loadFieldInjectors(Class clazz, Container container, ArrayList list) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        DependsHandler.loadFieldInjectors(clazz.getSuperclass(), container, list);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Depends dep = (Depends)((Advisor)((Object)container)).resolveAnnotation(fields[i], Depends.class);
            if (dep == null) continue;
            String[] names = dep.value();
            if (names.length != 1) {
                throw new RuntimeException("@Depends on a field can only take one object name: " + fields[i]);
            }
            ObjectName on = new ObjectName(names[0]);
            list.add(new DependsFieldInjector(fields[i], on));
        }
    }
}

