/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.sql.Types;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCMappingMetaData {
    private static Logger log = Logger.getLogger(JDBCMappingMetaData.class.getName());
    private final String javaType;
    private final int jdbcType;
    private final String sqlType;
    private final String paramSetter;
    private final String resultReader;

    public static int getJdbcTypeFromName(String name) throws DeploymentException {
        if (name == null) {
            throw new DeploymentException("jdbc-type cannot be null");
        }
        try {
            Integer constant = (Integer)Types.class.getField(name).get(null);
            return constant;
        }
        catch (Exception e) {
            log.warn("Unrecognized jdbc-type: " + name + ", using Types.OTHER", e);
            return 1111;
        }
    }

    public JDBCMappingMetaData(Element element) throws DeploymentException {
        this.javaType = MetaData.getUniqueChildContent(element, "java-type");
        this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(MetaData.getUniqueChildContent(element, "jdbc-type"));
        this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
        this.paramSetter = MetaData.getOptionalChildContent(element, "param-setter");
        this.resultReader = MetaData.getOptionalChildContent(element, "result-reader");
    }

    public String getJavaType() {
        return this.javaType;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public String getParamSetter() {
        return this.paramSetter;
    }

    public String getResultReader() {
        return this.resultReader;
    }
}

