/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.ejb.EjbUtil;
import org.jboss.metadata.ClientMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.naming.Util;
import org.jboss.webservice.WebServiceClientHandler;
import org.w3c.dom.Element;

public class ClientDeployer
extends SubDeployerSupport {
    protected void startService() throws Exception {
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.getFile();
        if (!urlStr.endsWith(".jar") && !urlStr.endsWith(".jar/")) {
            return false;
        }
        boolean accepts = false;
        try {
            URL dd = di.localCl.findResource("META-INF/application-client.xml");
            if (dd != null) {
                this.log.debug("Found a META-INF/application-client.xml file, di: " + di);
                accepts = true;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return accepts;
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        super.create(di);
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        ClientMetaData metaData = null;
        try {
            InputStream in = null;
            if (di.alternativeDD == null) {
                in = di.localCl.getResourceAsStream("META-INF/application-client.xml");
            } else {
                String contentsDir = new File(di.url.getPath()).getParent();
                in = new FileInputStream(contentsDir + "/" + di.alternativeDD);
            }
            if (in == null) {
                throw new DeploymentException("No META-INF/application-client.xml found");
            }
            metaData = null;
            XmlFileLoader xfl = new XmlFileLoader(true);
            Element appClient = xfl.getDocument(in, "META-INF/application-client.xml").getDocumentElement();
            in.close();
            metaData = new ClientMetaData();
            metaData.setResourceClassLoader(di.localCl);
            metaData.importClientXml(appClient);
            di.metaData = metaData;
            in = di.localCl.getResourceAsStream("META-INF/jboss-client.xml");
            if (in != null) {
                xfl = new XmlFileLoader(true);
                Element jbossClient = xfl.getDocument(in, "META-INF/jboss-client.xml").getDocumentElement();
                in.close();
                metaData.importJbossClientXml(jbossClient);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to parse metadata", e);
        }
        try {
            this.setupEnvironment(di, metaData);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to setup client ENC", e);
        }
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        ClientMetaData metaData = (ClientMetaData)di.metaData;
        if (metaData != null) {
            String appClientName = metaData.getJndiName();
            this.log.info("Removing client ENC from: " + appClientName);
            try {
                InitialContext iniCtx = new InitialContext();
                Util.unbind((Context)iniCtx, appClientName);
            }
            catch (NamingException e) {
                throw new DeploymentException("Failed to remove client ENC", e);
            }
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        super.destroy(di);
    }

    private void setupEnvironment(DeploymentInfo di, ClientMetaData metaData) throws Exception {
        String appClientName = metaData.getJndiName();
        InitialContext iniCtx = new InitialContext();
        Context envCtx = Util.createSubcontext((Context)iniCtx, appClientName);
        this.log.debug("Creating client ENC binding under: " + appClientName);
        for (EnvEntryMetaData entry : metaData.getEnvironmentEntries()) {
            this.log.debug("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue());
            EnvEntryMetaData.bindEnvEntry(envCtx, entry);
        }
        HashMap ejbRefs = metaData.getEjbReferences();
        for (EjbRefMetaData ref : ejbRefs.values()) {
            this.log.debug("Binding an EJBReference " + ref.getName());
            if (ref.getLink() != null) {
                String linkName = ref.getLink();
                String jndiName = EjbUtil.findEjbLink(this.server, di, linkName);
                this.log.debug("Binding " + ref.getName() + " to ejb-link: " + linkName + " -> " + jndiName);
                if (jndiName == null) {
                    String msg = "Failed to resolve ejb-link: " + linkName + " make by ejb-name: " + ref.getName();
                    throw new DeploymentException(msg);
                }
                this.log.debug("Link resolved to:" + jndiName);
                Util.bind(envCtx, ref.getName(), (Object)new LinkRef(jndiName));
                continue;
            }
            if (ref.getJndiName() == null) {
                throw new DeploymentException("ejb-ref " + ref.getName() + ", expected either ejb-link in ejb-jar.xml " + "or jndi-name in jboss.xml");
            }
            this.log.debug("Binding " + ref.getName() + " to : " + ref.getJndiName());
            Util.bind(envCtx, ref.getName(), (Object)new LinkRef(ref.getJndiName()));
        }
        Iterator serviceRefs = metaData.getServiceReferences().values().iterator();
        WebServiceClientHandler.setupServiceRefEnvironment(envCtx, serviceRefs, di);
        HashMap resRefs = metaData.getResourceReferences();
        for (ResourceRefMetaData ref : resRefs.values()) {
            String refName = ref.getRefName();
            String jndiName = ref.getJndiName();
            if (ref.getType().equals("java.net.URL")) {
                String resURL = ref.getResURL();
                if (resURL != null) {
                    this.log.debug("Binding '" + refName + "' to URL: " + resURL);
                    URL url = new URL(resURL);
                    Util.bind(envCtx, refName, (Object)url);
                    continue;
                }
                this.log.debug("Linking '" + refName + "' to URL: " + resURL);
                LinkRef urlLink = new LinkRef(jndiName);
                Util.bind(envCtx, refName, (Object)urlLink);
                continue;
            }
            this.log.debug("Binding resource: " + refName + " to JDNI as: " + jndiName);
            Util.bind(envCtx, refName, (Object)new LinkRef(jndiName));
        }
        HashMap envRefs = metaData.getResourceEnvReferences();
        for (ResourceEnvRefMetaData resRef : envRefs.values()) {
            String encName = resRef.getRefName();
            String jndiName = resRef.getJndiName();
            this.log.debug("Binding env resource: " + encName + " to JDNI as: " + jndiName);
            Util.bind(envCtx, encName, (Object)new LinkRef(jndiName));
        }
        this.log.info("Client ENC bound under: " + appClientName);
    }
}

