/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;

public class OptimizedConstructorInvocations
extends OptimizedBehaviourInvocations {
    protected static String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex) {
        return declaringClazz.getName() + "_" + constructorIndex + "OptimizedConstructorInvocation";
    }

    protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtConstructor con, int index) throws NotFoundException, CannotCompileException {
        CtClass invocation;
        boolean makeInnerClass;
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        String className = OptimizedConstructorInvocations.getOptimizedInvocationClassName(clazz, index);
        boolean bl = makeInnerClass = !Modifier.isPublic((int)con.getModifiers());
        if (makeInnerClass) {
            String innerClassName = className.substring(className.lastIndexOf(46) + 1);
            boolean classStatic = true;
            invocation = TransformerCommon.makeNestedClass(clazz, innerClassName, classStatic);
            invocation.setSuperclass(conInvocation);
        } else {
            try {
                CtClass existing = pool.get(className);
                existing.defrost();
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            invocation = TransformerCommon.makeClass(pool, className, conInvocation);
        }
        invocation.addInterface(untransformable);
        CtConstructor template = conInvocation.getDeclaredConstructors()[0];
        CtConstructor icon = CtNewConstructor.make((CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (CtClass)invocation);
        invocation.addConstructor(icon);
        CtClass[] params = con.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
        CtMethod in = conInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        StringBuffer code = new StringBuffer();
        code.append("{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)      {         throw t;       }      finally      {         currentInterceptor--;       }   } ");
        code.append("setTargetObject( new ").append(con.getDeclaringClass().getName()).append("(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code.append(", ");
            }
            code.append("arg").append(i);
        }
        code.append("));");
        code.append("return getTargetObject();");
        code.append("}");
        try {
            invokeNext.setBody(code.toString());
        }
        catch (CannotCompileException e) {
            System.out.println(code.toString());
            throw e;
        }
        invocation.addMethod(invokeNext);
        OptimizedConstructorInvocations.addGetArguments(pool, invocation, con.getParameterTypes());
        OptimizedConstructorInvocations.addCopy(pool, invocation, con.getParameterTypes());
        TransformerCommon.compileOrLoadClass(clazz, invocation);
        return invocation.getName();
    }

    private static void addCopy(ClassPool pool, CtClass invocation, CtClass[] params) throws CannotCompileException, NotFoundException {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        String code = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors); " + "   wrapper.constructor = this.constructor; " + "   wrapper.arguments = this.arguments; " + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; ";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        code = code + "   return wrapper; }";
        copy.setBody(code);
        invocation.addMethod(copy);
    }
}

