/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.bisocket;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.BidirectionalClientInvoker;
import org.jboss.remoting.transport.bisocket.BisocketServerInvoker;
import org.jboss.remoting.transport.socket.SocketClientInvoker;
import org.jboss.remoting.transport.socket.SocketWrapper;

public class BisocketClientInvoker
extends SocketClientInvoker
implements BidirectionalClientInvoker {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$bisocket$BisocketClientInvoker == null ? (class$org$jboss$remoting$transport$bisocket$BisocketClientInvoker = BisocketClientInvoker.class$("org.jboss.remoting.transport.bisocket.BisocketClientInvoker")) : class$org$jboss$remoting$transport$bisocket$BisocketClientInvoker);
    private static Map listenerIdToClientInvokerMap = Collections.synchronizedMap(new HashMap());
    private static Map listenerIdToCallbackClientInvokerMap = Collections.synchronizedMap(new HashMap());
    private static Map listenerIdToSocketsMap = new HashMap();
    private static Timer timer;
    private static Object timerLock;
    protected String listenerId;
    private int pingFrequency = 5000;
    private int maxRetries = 10;
    private Socket controlSocket;
    private OutputStream controlOutputStream;
    private Object controlLock = new Object();
    private PingTimerTask pingTimerTask;
    protected boolean isCallbackInvoker;
    static /* synthetic */ Class class$org$jboss$remoting$transport$bisocket$BisocketClientInvoker;

    static BisocketClientInvoker getBisocketClientInvoker(String listenerId) {
        return (BisocketClientInvoker)listenerIdToClientInvokerMap.get(listenerId);
    }

    static BisocketClientInvoker getBisocketCallbackClientInvoker(String listenerId) {
        return (BisocketClientInvoker)listenerIdToCallbackClientInvokerMap.get(listenerId);
    }

    static void removeBisocketClientInvoker(String listenerId) {
        listenerIdToClientInvokerMap.remove(listenerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void transferSocket(String listenerId, Socket socket) {
        HashSet<Socket> sockets = null;
        Object object = listenerIdToSocketsMap;
        synchronized (object) {
            sockets = (HashSet<Socket>)listenerIdToSocketsMap.get(listenerId);
            if (sockets == null) {
                sockets = new HashSet<Socket>();
                listenerIdToSocketsMap.put(listenerId, sockets);
            }
        }
        object = sockets;
        synchronized (object) {
            sockets.add(socket);
            sockets.notify();
        }
    }

    public BisocketClientInvoker(InvokerLocator locator) throws IOException {
        this(locator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BisocketClientInvoker(InvokerLocator locator, Map config) throws IOException {
        super(locator, config);
        if (this.configuration != null) {
            int nVal;
            Object val;
            this.listenerId = (String)this.configuration.get("listenerId");
            if (this.listenerId != null) {
                this.isCallbackInvoker = true;
                listenerIdToCallbackClientInvokerMap.put(this.listenerId, this);
                log.debug("registered " + this.listenerId + " -> " + this);
            }
            if ((val = this.configuration.get("pingFrequency")) != null) {
                try {
                    this.pingFrequency = nVal = Integer.valueOf((String)val).intValue();
                    log.debug("Setting ping frequency to: " + this.pingFrequency);
                }
                catch (Exception e) {
                    log.warn("Could not convert pingFrequency value of " + val + " to an int value.");
                }
            }
            if ((val = this.configuration.get("maxRetries")) != null) {
                try {
                    this.maxRetries = nVal = Integer.valueOf((String)val).intValue();
                    log.debug("Setting retry limit: " + this.maxRetries);
                }
                catch (Exception e) {
                    log.warn("Could not convert maxRetries value of " + val + " to an int value.");
                }
            }
        }
        if (this.isCallbackInvoker) {
            HashSet sockets = null;
            Object object = listenerIdToSocketsMap;
            synchronized (object) {
                sockets = (HashSet)listenerIdToSocketsMap.get(this.listenerId);
                if (sockets == null) {
                    sockets = new HashSet();
                    listenerIdToSocketsMap.put(this.listenerId, sockets);
                }
            }
            object = sockets;
            synchronized (object) {
                if (sockets.isEmpty()) {
                    try {
                        sockets.wait(this.timeout);
                    }
                    catch (InterruptedException ignored) {
                        log.warn("unexpected interrupt");
                        throw new InterruptedIOException("Attempt to create control socket interrupted");
                    }
                }
                if (sockets.isEmpty()) {
                    throw new IOException("Timed out trying to create control socket");
                }
                Iterator it = sockets.iterator();
                this.controlSocket = (Socket)it.next();
                it.remove();
                this.controlOutputStream = this.controlSocket.getOutputStream();
                log.debug("got control socket: " + this.controlSocket);
                this.pingTimerTask = new PingTimerTask(this);
                Object object2 = timerLock;
                synchronized (object2) {
                    if (timer == null) {
                        timer = new Timer(true);
                    }
                    try {
                        timer.schedule((TimerTask)this.pingTimerTask, this.pingFrequency, (long)this.pingFrequency);
                    }
                    catch (IllegalStateException e) {
                        log.debug("Unable to schedule TimerTask on existing Timer", e);
                        timer = new Timer(true);
                        timer.schedule((TimerTask)this.pingTimerTask, this.pingFrequency, (long)this.pingFrequency);
                    }
                }
            }
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getPingFrequency() {
        return this.pingFrequency;
    }

    public void setPingFrequency(int pingFrequency) {
        this.pingFrequency = pingFrequency;
    }

    protected void handleConnect() throws ConnectionFailedException {
        if (this.isCallbackInvoker) {
            this.pool = new LinkedList();
            return;
        }
        super.handleConnect();
    }

    protected void handleDisconnect() {
        if (this.listenerId != null) {
            if (this.isCallbackInvoker) {
                listenerIdToCallbackClientInvokerMap.remove(this.listenerId);
                Iterator it = this.pool.iterator();
                while (it.hasNext()) {
                    SocketWrapper socketWrapper = (SocketWrapper)it.next();
                    try {
                        socketWrapper.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                listenerIdToClientInvokerMap.remove(this.listenerId);
                super.handleDisconnect();
            }
            listenerIdToSocketsMap.remove(this.listenerId);
            if (this.pingTimerTask != null) {
                this.pingTimerTask.shutDown();
            }
        } else {
            super.handleDisconnect();
        }
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        InternalInvocation ii;
        InvocationRequest ir;
        Object o;
        if (invocation instanceof InvocationRequest && (o = (ir = (InvocationRequest)invocation).getParameter()) instanceof InternalInvocation && "addListener".equals((ii = (InternalInvocation)o).getMethodName()) && ir.getLocator() != null) {
            Map requestPayload = ir.getRequestPayload();
            this.listenerId = (String)requestPayload.get("listenerId");
            listenerIdToClientInvokerMap.put(this.listenerId, this);
            BisocketServerInvoker callbackServerInvoker = BisocketServerInvoker.getBisocketServerInvoker(this.listenerId);
            callbackServerInvoker.createControlConnection(this.listenerId, true);
        }
        return super.transport(sessionId, invocation, metadata, marshaller, unmarshaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        if (!this.isCallbackInvoker) {
            return super.createSocket(address, port, timeout);
        }
        if (timeout < 0 && (timeout = this.getTimeout()) < 0) {
            timeout = 0;
        }
        Set sockets = null;
        Object object = listenerIdToSocketsMap;
        synchronized (object) {
            sockets = (Set)listenerIdToSocketsMap.get(this.listenerId);
        }
        object = this.controlLock;
        synchronized (object) {
            this.controlOutputStream.write(3);
        }
        object = sockets;
        synchronized (object) {
            if (sockets.isEmpty()) {
                try {
                    sockets.wait(timeout);
                }
                catch (InterruptedException e) {
                    log.warn("unexpected interrupt");
                    throw new InterruptedIOException("Attempt to create callback socket interrupted");
                }
            }
            if (sockets.isEmpty()) {
                throw new IOException("Timed out trying to create socket");
            }
            Iterator it = sockets.iterator();
            Socket socket = (Socket)it.next();
            it.remove();
            log.debug("found socket: " + socket);
            return socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceControlSocket(Socket socket) throws IOException {
        Object object = this.controlLock;
        synchronized (object) {
            this.controlSocket = socket;
            this.controlOutputStream = this.controlSocket.getOutputStream();
            log.debug("replaced control socket");
        }
        if (this.pingTimerTask != null) {
            this.pingTimerTask.cancel();
        }
        this.pingTimerTask = new PingTimerTask(this);
        object = timerLock;
        synchronized (object) {
            timer = new Timer(true);
        }
        timer.schedule((TimerTask)this.pingTimerTask, this.pingFrequency, (long)this.pingFrequency);
    }

    InvokerLocator getSecondaryLocator() throws Throwable {
        InternalInvocation ii = new InternalInvocation("getSecondaryInvokerLocator", null);
        InvocationRequest r = new InvocationRequest(null, null, ii, null, null, null);
        log.debug("getting secondary locator");
        Exception savedException = null;
        for (int i = 0; i < this.maxRetries; ++i) {
            try {
                Object o = this.invoke(r);
                log.debug("secondary locator: " + o);
                return (InvokerLocator)o;
            }
            catch (Exception e) {
                savedException = e;
                log.debug("unable to get secondary locator: trying again");
                continue;
            }
        }
        throw savedException;
    }

    public InvokerLocator getCallbackLocator(Map metadata) {
        String transport = (String)metadata.get("callbackServerProtocol");
        String host = (String)metadata.get("callbackServerHost");
        String sPort = (String)metadata.get("callbackServerPort");
        int port = -1;
        if (sPort != null) {
            try {
                port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Can not set internal callback server port as configuration value (" + sPort + " is not a number.");
            }
        }
        return new InvokerLocator(transport, host, port, "callback", metadata);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        timerLock = new Object();
    }

    static class PingTimerTask
    extends TimerTask {
        private Object controlLock;
        private OutputStream controlOutputStream;
        private int maxRetries;
        private Exception savedException;
        private boolean pingSent;

        PingTimerTask(BisocketClientInvoker invoker) {
            this.controlLock = invoker.controlLock;
            this.controlOutputStream = invoker.controlOutputStream;
            this.maxRetries = invoker.getMaxRetries();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutDown() {
            Object object = this.controlLock;
            synchronized (object) {
                this.controlOutputStream = null;
            }
            this.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.pingSent = false;
            for (int i = 0; i < this.maxRetries; ++i) {
                try {
                    Object object = this.controlLock;
                    synchronized (object) {
                        this.controlOutputStream.write(1);
                    }
                    this.pingSent = true;
                    break;
                }
                catch (Exception e) {
                    this.savedException = e;
                    log.debug("Unable to send ping: trying again");
                    continue;
                }
            }
            if (!this.pingSent) {
                log.warn("Unable to send ping: shutting down PingTimerTask", this.savedException);
                this.shutDown();
            }
        }
    }
}

