/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.service;

import com.octo.captcha.Captcha;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.AbstractCaptchaService;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.EhcacheManageableCaptchaServiceMBean;
import com.octo.captcha.service.captchastore.EhcacheCaptchaStore;
import com.octo.captcha.service.captchastore.MapCaptchaStore;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EhcacheManageableCaptchaService
extends AbstractCaptchaService
implements EhcacheManageableCaptchaServiceMBean {
    private static Log log = LogFactory.getLog((Class)(class$com$octo$captcha$service$EhcacheManageableCaptchaService == null ? (class$com$octo$captcha$service$EhcacheManageableCaptchaService = EhcacheManageableCaptchaService.class$("com.octo.captcha.service.EhcacheManageableCaptchaService")) : class$com$octo$captcha$service$EhcacheManageableCaptchaService));
    private CacheManager cacheManager;
    private int minGuarantedStorageDelayInSeconds;
    private int captchaStoreMaxSize;
    private int numberOfGeneratedCaptchas = 0;
    private int numberOfCorrectResponse = 0;
    private int numberOfUncorrectResponse = 0;
    public static final String CACHE_NAME_PREFIX = "jcaptcha.store.";
    public static final String DEFAULT_CACHE_NAME = "default";
    public String captchaStoreCacheName;
    static /* synthetic */ Class class$com$octo$captcha$service$EhcacheManageableCaptchaService;

    protected EhcacheManageableCaptchaService(CaptchaEngine captchaEngine, int minGuarantedStorageDelayInSeconds, int maxCaptchaStoreSize) {
        this(captchaEngine, minGuarantedStorageDelayInSeconds, maxCaptchaStoreSize, DEFAULT_CACHE_NAME);
    }

    protected EhcacheManageableCaptchaService(CaptchaEngine captchaEngine, int minGuarantedStorageDelayInSeconds, int maxCaptchaStoreSize, String cacheName) {
        super(new MapCaptchaStore(), captchaEngine);
        if (cacheName == null || "".equals(cacheName)) {
            cacheName = DEFAULT_CACHE_NAME;
        }
        this.captchaStoreCacheName = CACHE_NAME_PREFIX + cacheName;
        try {
            this.cacheManager = CacheManager.getInstance();
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        Cache cache = new Cache(this.captchaStoreCacheName, maxCaptchaStoreSize, true, false, (long)minGuarantedStorageDelayInSeconds, (long)minGuarantedStorageDelayInSeconds);
        try {
            if (this.cacheManager.cacheExists(this.captchaStoreCacheName)) {
                this.cacheManager.removeCache(this.captchaStoreCacheName);
            }
            this.cacheManager.addCache(cache);
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        this.store = new EhcacheCaptchaStore(cache);
        this.captchaStoreMaxSize = maxCaptchaStoreSize;
        this.minGuarantedStorageDelayInSeconds = minGuarantedStorageDelayInSeconds;
    }

    public String getCaptchaEngineClass() {
        return this.engine.getClass().getName();
    }

    public void setCaptchaEngineClass(String theClassName) throws IllegalArgumentException {
        try {
            Object engine = Class.forName(theClassName).newInstance();
            if (!(engine instanceof CaptchaEngine)) {
                throw new IllegalArgumentException("Class is not instance of CaptchaEngine! " + theClassName);
            }
            this.engine = (CaptchaEngine)engine;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int getMinGuarantedStorageDelayInSeconds() {
        return this.minGuarantedStorageDelayInSeconds;
    }

    public void setMinGuarantedStorageDelayInSeconds(int theMinGuarantedStorageDelayInSeconds) {
        this.minGuarantedStorageDelayInSeconds = theMinGuarantedStorageDelayInSeconds;
        this.updateCache();
    }

    public long getNumberOfGeneratedCaptchas() {
        return this.numberOfGeneratedCaptchas;
    }

    public long getNumberOfCorrectResponses() {
        return this.numberOfCorrectResponse;
    }

    public long getNumberOfUncorrectResponses() {
        return this.numberOfUncorrectResponse;
    }

    public int getCaptchaStoreSize() {
        return this.store.getSize();
    }

    public int getNumberOfGarbageCollectableCaptchas() {
        return 0;
    }

    public long getNumberOfGarbageCollectedCaptcha() {
        return 0L;
    }

    public int getCaptchaStoreSizeBeforeGarbageCollection() {
        return 0;
    }

    public void setCaptchaStoreSizeBeforeGarbageCollection(int captchaStoreSizeBeforeGarbageCollection) {
        throw new UnsupportedOperationException("the max store size is useless for eh cache implementation");
    }

    public void setCaptchaStoreMaxSize(int size) {
        this.captchaStoreMaxSize = size;
        this.updateCache();
    }

    public int getCaptchaStoreMaxSize() {
        return this.captchaStoreMaxSize;
    }

    public void garbageCollectCaptchaStore() {
        Iterator it = null;
        try {
            it = this.cacheManager.getCache(this.captchaStoreCacheName).getKeys().iterator();
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        while (it.hasNext()) {
            try {
                this.cacheManager.getCache(this.captchaStoreCacheName).get((Serializable)((Object)it.next().toString()));
            }
            catch (CacheException e) {
                log.error((Object)e);
            }
        }
    }

    public void emptyCaptchaStore() {
        this.store.empty();
    }

    private void updateCache() {
        Cache cache = new Cache(this.captchaStoreCacheName, this.captchaStoreMaxSize, true, false, (long)this.minGuarantedStorageDelayInSeconds, (long)this.minGuarantedStorageDelayInSeconds);
        Iterator it = null;
        try {
            it = this.copyCacheContent().iterator();
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        try {
            this.cacheManager.removeCache(this.captchaStoreCacheName);
            this.cacheManager.addCache(cache);
            this.store = new EhcacheCaptchaStore(cache);
            Cache myCache = this.cacheManager.getCache(this.captchaStoreCacheName);
            long now = System.currentTimeMillis();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (now - el.getCreationTime() >= cache.getTimeToLiveSeconds() * 1000L) continue;
                myCache.put(el);
            }
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
    }

    private Collection copyCacheContent() throws CacheException {
        Cache currentcache = this.cacheManager.getCache(this.captchaStoreCacheName);
        Iterator it = this.store.getKeys().iterator();
        HashSet<Element> els = new HashSet<Element>();
        while (it.hasNext()) {
            Element el = currentcache.get((Serializable)((Object)it.next().toString()));
            if (el == null) continue;
            els.add(el);
        }
        return els;
    }

    protected Captcha generateAndStoreCaptcha(Locale locale, String ID) {
        if (this.store.getSize() >= this.captchaStoreMaxSize) {
            throw new CaptchaServiceException("Store is full, try to increase CaptchaStore Size or to decrease time out");
        }
        Captcha captcha = this.engine.getNextCaptcha(locale);
        ++this.numberOfGeneratedCaptchas;
        this.store.storeCaptcha(ID, captcha, locale);
        return captcha;
    }

    public Boolean validateResponseForID(String ID, Object response) throws CaptchaServiceException {
        Boolean valid = super.validateResponseForID(ID, response);
        if (valid.booleanValue()) {
            ++this.numberOfCorrectResponse;
        } else {
            ++this.numberOfUncorrectResponse;
        }
        return valid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

