/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.module.filter;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

public class FilterConfigUtils {
    public static String getStringInitParameter(FilterConfig theFilterConfig, String theInitParameterName, boolean isMandatory) throws ServletException {
        String returnedValue = theFilterConfig.getInitParameter(theInitParameterName);
        if (isMandatory && returnedValue == null) {
            throw new ServletException(theInitParameterName + " parameter must be declared for " + theFilterConfig.getFilterName() + " in web.xml");
        }
        return returnedValue;
    }

    public static Integer getIntegerInitParameter(FilterConfig theFilterConfig, String theInitParameterName, boolean isMandatory, int theMinValue, int theMaxValue) throws ServletException {
        Integer returnedValue = null;
        String returnedValueAsString = theFilterConfig.getInitParameter(theInitParameterName);
        if (isMandatory && returnedValueAsString == null) {
            throw new ServletException(theInitParameterName + " parameter must be declared for " + theFilterConfig.getFilterName() + " in web.xml");
        }
        try {
            returnedValue = new Integer(returnedValueAsString);
        }
        catch (NumberFormatException e) {
            throw new ServletException(theInitParameterName + " parameter must be an integer value " + theFilterConfig.getFilterName() + " in web.xml");
        }
        if (returnedValue < theMinValue || returnedValue > theMaxValue) {
            throw new ServletException(theInitParameterName + " parameter for " + theFilterConfig.getFilterName() + " in web.xml must be >= " + theMinValue + " and <= " + theMaxValue);
        }
        return returnedValue;
    }

    public static boolean getBooleanInitParameter(FilterConfig theFilterConfig, String theInitParameterName, boolean isMandatory) throws ServletException {
        String returnedValueAsString = theFilterConfig.getInitParameter(theInitParameterName);
        if (isMandatory && returnedValueAsString == null) {
            throw new ServletException(theInitParameterName + " parameter must be declared for " + theFilterConfig.getFilterName() + " in web.xml");
        }
        boolean returnedValue = false;
        if (returnedValueAsString != null) {
            returnedValue = new Boolean(returnedValueAsString);
        }
        return returnedValue;
    }
}

