/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.apache.ftpserver.ConfigurableFtpServerContext;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.config.PropertiesConfiguration;
import org.apache.ftpserver.config.XmlConfigurationHandler;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.gui.GuiUtils;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.IoUtils;

public class RootPanel
extends PluginPanel {
    private static final long serialVersionUID = 6048031185986894615L;
    private JTextField cfgFileTxt;
    private JRadioButton cfgPropRadio;
    private JRadioButton cfgXmlRadio;
    private JRadioButton cfgFileRadio;
    private JRadioButton cfgClasspathRadio;
    private JButton browseButton;
    private JButton startButton;
    private JButton stopButton;
    private JToggleButton suspendButton;
    private FtpServer server;

    public RootPanel(PluginPanelContainer container) {
        super(container);
        this.initComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel topPnl = new JPanel(new GridBagLayout());
        this.add((Component)topPnl, "North");
        GridBagConstraints gc = new GridBagConstraints();
        int yindex = -1;
        gc.insets = new Insets(0, 0, 0, 10);
        JLabel cfgLab = new JLabel("Configuration", 0);
        cfgLab.setForeground(Color.darkGray);
        cfgLab.setFont(new Font(null, 1, 14));
        gc.gridx = 0;
        ++yindex;
        gc.gridy = yindex++;
        gc.gridwidth = 4;
        gc.fill = 2;
        topPnl.add((Component)cfgLab, gc);
        JLabel cfgFileLab = new JLabel("File :: ", 4);
        cfgFileLab.setFont(new Font(null, 1, 12));
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.fill = 2;
        topPnl.add((Component)cfgFileLab, gc);
        this.cfgFileTxt = new JTextField();
        this.cfgFileTxt.setText("./res/conf/ftpd.properties");
        gc.fill = 2;
        gc.gridx = 1;
        gc.gridy = yindex;
        gc.gridwidth = 2;
        topPnl.add((Component)this.cfgFileTxt, gc);
        this.browseButton = new JButton("Browse");
        this.browseButton.setPreferredSize(new Dimension(80, 22));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                File currFile = new File(RootPanel.this.cfgFileTxt.getText());
                JFileChooser fileChoose = new JFileChooser(currFile.getParentFile());
                fileChoose.setFileSelectionMode(0);
                int returnVal = fileChoose.showOpenDialog(RootPanel.this);
                if (returnVal == 0) {
                    String path = fileChoose.getSelectedFile().getAbsolutePath();
                    RootPanel.this.cfgFileTxt.setText(path);
                }
            }
        });
        gc.fill = 2;
        gc.gridx = 3;
        gc.gridy = yindex++;
        gc.gridwidth = 1;
        topPnl.add((Component)this.browseButton, gc);
        JLabel cfgSrcLab = new JLabel("Source :: ", 4);
        cfgSrcLab.setFont(new Font(null, 1, 12));
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        topPnl.add((Component)cfgSrcLab, gc);
        this.cfgFileRadio = new JRadioButton("File System");
        this.cfgFileRadio.setFont(new Font(null, 1, 12));
        this.cfgFileRadio.setSelected(true);
        this.cfgFileRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RootPanel.this.browseButton.setEnabled(RootPanel.this.cfgFileRadio.isSelected());
            }
        });
        gc.gridx = 1;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        topPnl.add((Component)this.cfgFileRadio, gc);
        this.cfgClasspathRadio = new JRadioButton("Classpath");
        this.cfgClasspathRadio.setFont(new Font(null, 1, 12));
        this.cfgClasspathRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RootPanel.this.browseButton.setEnabled(!RootPanel.this.cfgClasspathRadio.isSelected());
            }
        });
        gc.gridx = 2;
        gc.gridy = yindex++;
        gc.gridwidth = 1;
        topPnl.add((Component)this.cfgClasspathRadio, gc);
        JLabel cfgTypLab = new JLabel("Type :: ", 4);
        cfgTypLab.setFont(new Font(null, 1, 12));
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        topPnl.add((Component)cfgTypLab, gc);
        this.cfgPropRadio = new JRadioButton("Properties");
        this.cfgPropRadio.setFont(new Font(null, 1, 12));
        this.cfgPropRadio.setSelected(true);
        gc.gridx = 1;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        topPnl.add((Component)this.cfgPropRadio, gc);
        this.cfgXmlRadio = new JRadioButton("XML");
        this.cfgXmlRadio.setFont(new Font(null, 1, 12));
        gc.gridx = 2;
        gc.gridy = yindex++;
        gc.gridwidth = 1;
        topPnl.add((Component)this.cfgXmlRadio, gc);
        JPanel btnPnl = new JPanel(new FlowLayout(1));
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 4;
        topPnl.add((Component)btnPnl, gc);
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RootPanel.this.startServer();
            }
        });
        btnPnl.add(this.startButton);
        this.stopButton = new JButton("Stop");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RootPanel.this.stopServer();
            }
        });
        btnPnl.add(this.stopButton);
        this.suspendButton = new JToggleButton("Suspend");
        this.suspendButton.setEnabled(false);
        this.suspendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RootPanel.this.suspendServer();
            }
        });
        btnPnl.add(this.suspendButton);
        JTextArea txtArea = new JTextArea();
        txtArea.setFont(new Font("Monospaced", 0, 10));
        txtArea.setEditable(false);
        InputStream is = null;
        InputStreamReader rd = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/ftpserver/gui/LICENSE.txt");
            if (is != null) {
                rd = new InputStreamReader(is);
                txtArea.read(rd, null);
            }
        }
        catch (IOException ex) {
        }
        finally {
            IoUtils.close(rd);
            IoUtils.close((InputStream)is);
        }
        JScrollPane editorScrollPane = new JScrollPane(txtArea);
        this.add((Component)editorScrollPane, "Center");
        ButtonGroup typeButtonGroup = new ButtonGroup();
        typeButtonGroup.add(this.cfgPropRadio);
        typeButtonGroup.add(this.cfgXmlRadio);
        ButtonGroup sourceButtonGroup = new ButtonGroup();
        sourceButtonGroup.add(this.cfgFileRadio);
        sourceButtonGroup.add(this.cfgClasspathRadio);
    }

    public void refresh(FtpServerContext serverContext) {
    }

    public boolean canBeDisplayed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() {
        InputStream in;
        block10: {
            if (this.server != null) {
                return;
            }
            in = null;
            String path = this.cfgFileTxt.getText();
            if (this.cfgFileRadio.isSelected()) {
                in = new FileInputStream(path);
                break block10;
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if ((in = this.getClass().getClassLoader().getResourceAsStream(path)) != null) break block10;
            GuiUtils.showErrorMessage(this, "Configuration file " + path + " not found in classpath" + " nor inside any of classpath JARs.");
            IoUtils.close((InputStream)in);
            return;
        }
        try {
            PropertiesConfiguration config = null;
            if (this.cfgPropRadio.isSelected()) {
                config = new PropertiesConfiguration(in);
            } else {
                XmlConfigurationHandler xmlHandler = new XmlConfigurationHandler(in);
                config = xmlHandler.parse();
            }
            ConfigurableFtpServerContext serverContext = new ConfigurableFtpServerContext((Configuration)config);
            this.server = new FtpServer((FtpServerContext)serverContext);
            this.server.start();
            this.cfgFileTxt.setEnabled(false);
            this.cfgPropRadio.setEnabled(false);
            this.cfgXmlRadio.setEnabled(false);
            this.cfgFileRadio.setEnabled(false);
            this.cfgClasspathRadio.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.startButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.suspendButton.setEnabled(true);
            this.suspendButton.setSelected(false);
            this.getContainer().refresh(this.server.getServerContext());
        }
        catch (Exception ex) {
            try {
                this.server = null;
                ex.printStackTrace();
                GuiUtils.showErrorMessage(this, "Cannot start FTP server.");
            }
            catch (Throwable throwable) {
                IoUtils.close(in);
                throw throwable;
            }
            IoUtils.close((InputStream)in);
        }
        IoUtils.close((InputStream)in);
    }

    public void stopServer() {
        if (this.server == null) {
            return;
        }
        this.server.stop();
        this.server = null;
        this.cfgFileTxt.setEnabled(true);
        this.cfgPropRadio.setEnabled(true);
        this.cfgXmlRadio.setEnabled(true);
        this.cfgFileRadio.setEnabled(true);
        this.cfgClasspathRadio.setEnabled(true);
        this.browseButton.setEnabled(true);
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.suspendButton.setEnabled(false);
        this.suspendButton.setSelected(false);
        this.getContainer().refresh(null);
    }

    private void suspendServer() {
        if (this.server == null) {
            return;
        }
        if (this.suspendButton.isSelected()) {
            this.server.suspend();
        } else {
            this.server.resume();
        }
    }

    public String toString() {
        return "FTP";
    }
}

