/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.gui.FtpFileTableModel;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Connection;

public class FilePanel
extends PluginPanel {
    private static final long serialVersionUID = 3172324853152800934L;
    private static final String[] HEADERS = new String[]{"Uploaded", "Downloaded", "Deleted"};
    private FtpServerContext serverContext;
    private FtpFileTableModel[] models;

    public FilePanel(PluginPanelContainer container) {
        super(container);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabPane = new JTabbedPane();
        this.add((Component)tabPane, "Center");
        this.models = new FtpFileTableModel[3];
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i] = new FtpFileTableModel();
            tabPane.addTab(HEADERS[i], this.createTabComponent(i));
        }
    }

    private JComponent createTabComponent(final int index) {
        JPanel panel = new JPanel(new BorderLayout());
        JTable fileTable = new JTable(this.models[index]);
        fileTable.setPreferredScrollableViewportSize(new Dimension(470, 300));
        fileTable.setColumnSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(fileTable, 20, 30);
        panel.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel();
        JButton jResetBtn = new JButton("Clear");
        bottomPanel.add(jResetBtn);
        panel.add((Component)bottomPanel, "South");
        jResetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilePanel.this.models[index].clear();
            }
        });
        return panel;
    }

    public void notifyUpload(Connection con, FileObject file, long sz) {
        User user = con.getSession().getUser();
        this.models[0].newEntry(file.getFullName(), user);
    }

    public void notifyDownload(Connection con, FileObject file, long sz) {
        User user = con.getSession().getUser();
        this.models[1].newEntry(file.getFullName(), user);
    }

    public void notifyDelete(Connection con, FileObject file) {
        User user = con.getSession().getUser();
        this.models[2].newEntry(file.getFullName(), user);
    }

    public void refresh(FtpServerContext serverContext) {
        this.serverContext = serverContext;
    }

    public boolean canBeDisplayed() {
        return this.serverContext != null;
    }

    public String toString() {
        return "File";
    }
}

