/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.ftpserver.gui.FtpConnectionTableModel;
import org.apache.ftpserver.gui.GuiUtils;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.gui.SpyPanelContainer;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Connection;

public class ConnectionPanel
extends PluginPanel {
    private static final long serialVersionUID = 3774741162954995177L;
    private FtpServerContext serverContext;
    private JTable conTable;
    private FtpConnectionTableModel model = new FtpConnectionTableModel();

    public ConnectionPanel(PluginPanelContainer container) {
        super(container);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.conTable = new JTable(this.model);
        this.conTable.setPreferredScrollableViewportSize(new Dimension(470, 320));
        this.conTable.setColumnSelectionAllowed(false);
        JScrollPane bottomPane = new JScrollPane(this.conTable, 20, 30);
        this.add((Component)bottomPane, "Center");
        JPanel btnPane = new JPanel(new FlowLayout(1));
        JButton jDisconnectBtn = new JButton("Disconnect");
        btnPane.add(jDisconnectBtn);
        JButton jSpyBtn = new JButton("Spy User");
        btnPane.add(jSpyBtn);
        JButton jReloadBtn = new JButton("Reload");
        btnPane.add(jReloadBtn);
        this.add((Component)btnPane, "South");
        jDisconnectBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.closeConnection();
            }
        });
        jSpyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.spyUser();
            }
        });
        jReloadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.refresh(ConnectionPanel.this.serverContext);
            }
        });
    }

    private void closeConnection() {
        int[] indices = this.conTable.getSelectedRows();
        if (indices.length == 0) {
            GuiUtils.showErrorMessage(this, "Please select connection(s).");
            return;
        }
        boolean response = GuiUtils.getConfirmation(this, "Do you really want to close the selected connection(s)?");
        if (!response) {
            return;
        }
        int i = indices.length;
        while (--i >= 0) {
            Connection con = this.model.getConnection(indices[i]);
            if (con == null) continue;
            this.serverContext.getConnectionManager().closeConnection(con);
        }
    }

    private void spyUser() {
        int[] indices = this.conTable.getSelectedRows();
        if (indices.length == 0) {
            GuiUtils.showErrorMessage(this, "Please select connection(s).");
            return;
        }
        SpyPanelContainer spyContainer = (SpyPanelContainer)this.getContainer().getPluginPanel(5);
        int i = indices.length;
        while (--i >= 0) {
            Connection con = this.model.getConnection(indices[i]);
            if (con == null) continue;
            spyContainer.monitorConnection(con);
        }
        this.getContainer().setSelectedIndex(5);
    }

    public void refresh(FtpServerContext ftpConfig) {
        this.serverContext = ftpConfig;
        this.model.refresh(ftpConfig);
    }

    public boolean canBeDisplayed() {
        return this.serverContext != null;
    }

    public String toString() {
        return "Connections";
    }
}

