/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import java.util.Iterator;
import org.apache.commons.lang.ClassUtils;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.def.LinkDefinition;
import org.jbpm.bpel.xml.BpelReader;
import org.jbpm.bpel.xml.ParseProblem;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class ActivityReader {
    protected BpelReader bpelReader;

    protected ActivityReader() {
    }

    public abstract Activity read(Element var1, CompositeActivity var2);

    protected void readStandardProperties(Element activityElem, Activity activity, CompositeActivity parent) {
        String name = XmlUtil.getAttribute(activityElem, "name");
        if (name == null) {
            name = ActivityReader.generateName(activity, parent);
            activity.setNameGenerated(true);
        }
        activity.setName(name);
        Attr suppressAttr = activityElem.getAttributeNode("suppressJoinFailure");
        activity.setSuppressJoinFailure(this.bpelReader.readTBoolean(suppressAttr, null));
        this.readTargets(activityElem, activity, parent);
        this.readSources(activityElem, activity, parent);
        parent.addNode(activity);
    }

    private static String generateName(Activity activity, CompositeActivity parent) {
        String name;
        String activityClass = ClassUtils.getShortClassName(((Object)((Object)activity)).getClass());
        StringBuffer nameBuffer = new StringBuffer(activityClass);
        nameBuffer.append('#');
        int baseLength = nameBuffer.length();
        int i = 1;
        while (parent.hasNode(name = nameBuffer.append(i).toString())) {
            nameBuffer.setLength(baseLength);
            ++i;
        }
        return name;
    }

    protected void readSources(Element activityElem, Activity activity, CompositeActivity parent) {
        Element sourcesElem = XmlUtil.getElement(activityElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "sources");
        if (sourcesElem == null) {
            return;
        }
        Iterator sourceElemIt = XmlUtil.getElements(sourcesElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "source");
        while (sourceElemIt.hasNext()) {
            Element sourceElem = (Element)sourceElemIt.next();
            String linkName = sourceElem.getAttribute("linkName");
            LinkDefinition link = parent.findLink(linkName);
            activity.addSource(link);
            Element conditionElem = XmlUtil.getElement(sourceElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "transitionCondition");
            if (conditionElem == null) continue;
            link.setTransitionCondition(this.bpelReader.readExpression(conditionElem, parent));
        }
    }

    protected void readTargets(Element activityElem, Activity activity, CompositeActivity parent) {
        Element targetsElem = XmlUtil.getElement(activityElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "targets");
        if (targetsElem == null) {
            return;
        }
        Iterator targetElemIt = XmlUtil.getElements(targetsElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "target");
        while (targetElemIt.hasNext()) {
            Element targetElem = (Element)targetElemIt.next();
            String linkName = targetElem.getAttribute("linkName");
            activity.addTarget(parent.findLink(linkName));
        }
        Element conditionElem = XmlUtil.getElement(targetsElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "joinCondition");
        if (conditionElem != null) {
            activity.setJoinCondition(this.bpelReader.readJoinCondition(conditionElem, parent));
        }
    }

    protected void validateNonInitial(Element activityElem, Activity activity) {
        if (activity.isInitial()) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("activity cannot be initial", activityElem));
        }
    }

    public BpelReader getBpelReader() {
        return this.bpelReader;
    }

    public void setBpelReader(BpelReader bpelReader) {
        this.bpelReader = bpelReader;
    }
}

