/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.persistence.db;

import java.util.Collection;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.persistence.db.DbPersistenceService;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.persistence.PersistenceService;

public class ScopeSession {
    private Session session;

    public ScopeSession(Session session) {
        this.session = session;
    }

    protected ScopeSession() {
    }

    public ScopeInstance nextChildToCompensate(ScopeInstance enclosingInstance) {
        Collection innerScopes = enclosingInstance.getDefinition().findNestedScopes();
        return innerScopes.isEmpty() ? null : this.findNextScopeToCompensate(enclosingInstance.getToken().getProcessInstance(), innerScopes);
    }

    public ScopeInstance nextScopeToCompensate(ProcessInstance processInstance, Scope targetScope) {
        Collection nestedScopes = targetScope.findNestedScopes();
        nestedScopes.add(targetScope);
        return this.findNextScopeToCompensate(processInstance, nestedScopes);
    }

    protected ScopeInstance findNextScopeToCompensate(ProcessInstance processInstance, Collection nestedScopes) {
        return (ScopeInstance)this.session.getNamedQuery("ScopeSession.findNextScopeToCompensate").setParameter("processInstance", (Object)processInstance).setParameterList("nestedScopes", nestedScopes).setMaxResults(1).uniqueResult();
    }

    public static ScopeSession getInstance(JbpmContext jbpmContext) {
        ScopeSession scopeSession = null;
        PersistenceService persistenceService = jbpmContext.getServices().getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            scopeSession = ((DbPersistenceService)persistenceService).getScopeSession();
        }
        return scopeSession;
    }
}

