/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.persistence.db;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.integration.exe.PartnerLinkInstance;
import org.jbpm.bpel.persistence.db.DbPersistenceService;
import org.jbpm.persistence.PersistenceService;

public class IntegrationSession {
    private Session session;

    public IntegrationSession(Session session) {
        this.session = session;
    }

    protected IntegrationSession() {
    }

    public PartnerLinkDefinition loadPartnerLinkDefinition(long id) {
        return (PartnerLinkDefinition)this.session.load(PartnerLinkDefinition.class, (Serializable)new Long(id));
    }

    public PartnerLinkInstance loadPartnerLinkInstance(long id) {
        return (PartnerLinkInstance)this.session.load(PartnerLinkInstance.class, (Serializable)new Long(id));
    }

    public ReceiveAction loadReceiver(long id) {
        return (ReceiveAction)this.session.load(ReceiveAction.class, (Serializable)new Long(id));
    }

    public Collection findReceiveTokens(BpelProcessDefinition processDefinition) {
        return this.session.getNamedQuery("IntegrationSession.findReceiveTokens").setEntity("processDefinition", (Object)processDefinition).list();
    }

    public Collection findPickTokens(BpelProcessDefinition processDefinition) {
        List tokens = this.session.getNamedQuery("IntegrationSession.findPickTokens").setEntity("processDefinition", (Object)processDefinition).list();
        return new HashSet(tokens);
    }

    public Collection findEventTokens(BpelProcessDefinition processDefinition) {
        List tokens = this.session.getNamedQuery("IntegrationSession.findEventTokens").setEntity("processDefinition", (Object)processDefinition).list();
        return new HashSet(tokens);
    }

    public static IntegrationSession getInstance(JbpmContext jbpmContext) {
        IntegrationSession integrationSession = null;
        PersistenceService persistenceService = jbpmContext.getServices().getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            integrationSession = ((DbPersistenceService)persistenceService).getIntegrationSession();
        }
        return integrationSession;
    }
}

