/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.soap;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.commons.lang.enums.Enum;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;

public abstract class FaultFormat
extends Enum {
    public static final FaultFormat DEFAULT = new FaultFormat("default"){
        private static final long serialVersionUID = 1L;

        SOAPElement addFault(SOAPBody body) throws SOAPException {
            return body.addFault();
        }

        void setCode(SOAPElement faultElem, QName code) throws SOAPException {
            SOAPFault fault = (SOAPFault)faultElem;
            SOAPEnvelope envelope = (SOAPEnvelope)faultElem.getParentElement().getParentElement();
            fault.setFaultCode(envelope.createName(code.getLocalPart(), code.getPrefix(), code.getNamespaceURI()));
        }

        void setReason(SOAPElement faultElem, String reason) throws SOAPException {
            SOAPFault fault = (SOAPFault)faultElem;
            fault.setFaultString(reason);
        }

        void addDetail(SOAPElement faultElem, Map parts) throws SOAPException {
            SOAPFault f = (SOAPFault)faultElem;
            Detail detail = f.addDetail();
            Iterator partIt = parts.values().iterator();
            while (partIt.hasNext()) {
                Element part = (Element)partIt.next();
                XmlUtil.copyChildElement((SOAPElement)detail, part);
            }
        }
    };
    public static final FaultFormat RAW = new FaultFormat("raw"){
        private static final long serialVersionUID = 1L;

        SOAPElement addFault(SOAPBody body) throws SOAPException {
            SOAPEnvelope envelope = (SOAPEnvelope)body.getParentElement();
            Name faultName = envelope.createName("Fault", body.getPrefix(), body.getNamespaceURI());
            return body.addBodyElement(faultName);
        }

        void setCode(SOAPElement faultElem, QName code) throws SOAPException {
            SOAPElement codeElem = XmlUtil.addChildElement(faultElem, "faultcode");
            XmlUtil.setQNameValue(codeElem, code);
        }

        void setReason(SOAPElement faultElem, String reason) throws SOAPException {
            SOAPElement stringElem = XmlUtil.addChildElement(faultElem, "faultstring");
            stringElem.setValue(reason);
        }

        void addDetail(SOAPElement faultElem, Map parts) throws SOAPException {
            SOAPElement detail = XmlUtil.addChildElement(faultElem, "detail");
            Iterator partIt = parts.values().iterator();
            while (partIt.hasNext()) {
                Element part = (Element)partIt.next();
                XmlUtil.copyChildElement(detail, part);
            }
        }
    };

    private FaultFormat(String name) {
        super(name);
    }

    abstract SOAPElement addFault(SOAPBody var1) throws SOAPException;

    abstract void setCode(SOAPElement var1, QName var2) throws SOAPException;

    abstract void setReason(SOAPElement var1, String var2) throws SOAPException;

    abstract void addDetail(SOAPElement var1, Map var2) throws SOAPException;
}

