/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.def;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.bpel.integration.def.Correlation;
import org.jbpm.bpel.integration.exe.CorrelationSetInstance;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.exe.Token;

public class Correlations
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    private Map correlations;

    public void addCorrelation(Correlation correlation) {
        if (this.correlations == null) {
            this.correlations = new HashMap();
        }
        this.correlations.put(correlation.getSet().getName(), correlation);
    }

    public Correlation getCorrelation(String setName) {
        return (Correlation)this.correlations.get(setName);
    }

    public Map getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Map correlations) {
        this.correlations = correlations;
    }

    public Map getReceptionProperties(Token token) {
        HashMap receptionProperties = new HashMap();
        Iterator correlationIter = this.correlations.values().iterator();
        while (correlationIter.hasNext()) {
            Correlation correlation = (Correlation)correlationIter.next();
            Correlation.Initiate initiate = correlation.getInitiate();
            if (initiate == Correlation.Initiate.YES) continue;
            CorrelationSetInstance setInstance = correlation.getSet().getInstance(token);
            if (initiate != Correlation.Initiate.NO && !setInstance.isInitialized()) continue;
            receptionProperties.putAll(setInstance.getProperties());
        }
        return receptionProperties;
    }

    public void ensureConstraint(MessageValue messageValue, Token token) {
        Iterator correlationIter = this.correlations.values().iterator();
        while (correlationIter.hasNext()) {
            Correlation correlation = (Correlation)correlationIter.next();
            CorrelationSetInstance setInstance = correlation.getSet().getInstance(token);
            Correlation.Initiate initiate = correlation.getInitiate();
            if (initiate == Correlation.Initiate.YES) {
                setInstance.initialize(messageValue);
                continue;
            }
            if (initiate == Correlation.Initiate.NO) {
                setInstance.validateConstraint(messageValue);
                continue;
            }
            if (initiate == Correlation.Initiate.JOIN) {
                if (setInstance.isInitialized()) {
                    setInstance.validateConstraint(messageValue);
                    continue;
                }
                setInstance.initialize(messageValue);
                continue;
            }
            throw new IllegalStateException("illegal property value: initiate=" + (Object)((Object)initiate));
        }
    }
}

