/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.struct;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.struct.StructuredActivity;
import org.jbpm.bpel.sublang.def.Expression;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class While
extends StructuredActivity {
    private static final long serialVersionUID = 1L;
    private Expression condition;
    private Loop loop = new Loop(this);
    static /* synthetic */ Class class$org$jbpm$bpel$graph$struct$While$Loop;
    static /* synthetic */ Class class$org$jbpm$bpel$graph$struct$While;

    public While() {
    }

    public While(String name) {
        super(name);
    }

    protected void addActivity(Activity activity) {
        if (this.nodes != null && !this.nodes.isEmpty()) {
            this.removeActivity((Activity)((Object)this.nodes.get(0)));
        }
        super.addActivity(activity);
    }

    protected void addImplicitTransitions(Activity activity) {
        if (!this.getEvaluateFirst()) {
            this.begin.connect(activity);
        }
        this.loop.connect(activity);
        activity.connect(this.loop);
    }

    protected void removeImplicitTransitions(Activity activity) {
        if (!this.getEvaluateFirst()) {
            this.begin.disconnect(activity);
        }
        this.loop.disconnect(activity);
        activity.disconnect(this.loop);
    }

    public boolean getEvaluateFirst() {
        return this.begin.isConnected(this.loop);
    }

    public void setEvaluateFirst(boolean evaluateFirst) {
        if (evaluateFirst == this.getEvaluateFirst()) {
            return;
        }
        if (evaluateFirst) {
            this.begin.connect(this.loop);
        } else {
            this.begin.disconnect(this.loop);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Loop getLoop() {
        return this.loop;
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }

    public static class Loop
    extends Activity {
        private static ThreadLocal entranceLocal;
        private Log log = LogFactory.getLog((Class)(class$org$jbpm$bpel$graph$struct$While$Loop == null ? (class$org$jbpm$bpel$graph$struct$While$Loop = While.class$("org.jbpm.bpel.graph.struct.While$Loop")) : class$org$jbpm$bpel$graph$struct$While$Loop));
        private static final long serialVersionUID = 1L;
        private static final Boolean FIRST_ENTRANCE;
        private static final Boolean REENTRANCE;
        static final /* synthetic */ boolean $assertionsDisabled;

        Loop() {
        }

        Loop(While _while) {
            super("loop");
            _while.adoptActivity((Activity)this);
            _while.getBegin().connect(this);
            this.connect(_while.getEnd());
        }

        public While getWhile() {
            CompositeActivity composite = this.getCompositeActivity();
            if (composite == null) {
                return null;
            }
            if (composite instanceof While) {
                return (While)composite;
            }
            Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
            While _while = (While)((Object)hbSession.load(class$org$jbpm$bpel$graph$struct$While == null ? (class$org$jbpm$bpel$graph$struct$While = While.class$("org.jbpm.bpel.graph.struct.While")) : class$org$jbpm$bpel$graph$struct$While, (Serializable)new Long(composite.getId())));
            _while.adoptActivity((Activity)this);
            return _while;
        }

        public void execute(ExecutionContext exeContext) {
            Boolean mark;
            if (this.getMark() == FIRST_ENTRANCE) {
                this.setMark(REENTRANCE);
                this.log.debug((Object)("reentrance detected on '" + (Object)((Object)this) + "' for '" + exeContext.getToken() + "', returning"));
                return;
            }
            Expression condition = this.getWhile().getCondition();
            Transition loopTransition = (Transition)this.getLeavingTransitions().get(1);
            Token token = exeContext.getToken();
            do {
                mark = null;
                this.log.debug((Object)("evaluating condition '" + condition.getText() + "' for '" + token + "'"));
                if (DatatypeUtil.toBoolean(condition.getEvaluator().evaluate(token))) {
                    this.setMark(FIRST_ENTRANCE);
                    this.leave(exeContext, loopTransition);
                    mark = this.removeMark();
                    if (!$assertionsDisabled && mark == null) {
                        throw new AssertionError((Object)"entrance mark not found");
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    if (mark == FIRST_ENTRANCE) {
                        this.log.debug((Object)("wait state reached from '" + (Object)((Object)this) + "' for '" + token + "'"));
                        continue;
                    }
                    this.log.debug((Object)("continue on '" + (Object)((Object)this) + "' for '" + token + "'"));
                    continue;
                }
                this.leave(exeContext, (Transition)this.getLeavingTransitions().get(0));
                this.log.debug((Object)("break on '" + (Object)((Object)this) + "' for '" + token + "'"));
            } while (mark == REENTRANCE);
        }

        private Boolean getMark() {
            return (Boolean)Loop.getEntranceMarks().get((Object)this);
        }

        private void setMark(Boolean mark) {
            Loop.getEntranceMarks().put(this, mark);
        }

        private Boolean removeMark() {
            return (Boolean)Loop.getEntranceMarks().remove((Object)this);
        }

        private static Map getEntranceMarks() {
            return (Map)entranceLocal.get();
        }

        static {
            $assertionsDisabled = !(class$org$jbpm$bpel$graph$struct$While == null ? (class$org$jbpm$bpel$graph$struct$While = While.class$("org.jbpm.bpel.graph.struct.While")) : class$org$jbpm$bpel$graph$struct$While).desiredAssertionStatus();
            entranceLocal = new ThreadLocal(){

                protected Object initialValue() {
                    return new HashMap();
                }
            };
            FIRST_ENTRANCE = Boolean.TRUE;
            REENTRANCE = Boolean.FALSE;
        }
    }
}

