/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.scope;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.state.ActiveState;
import org.jbpm.bpel.graph.scope.Handler;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.integration.def.InboundMessageActivity;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class OnEvent
extends Handler
implements InboundMessageActivity {
    private VariableDefinition variable;
    private static final Log log = LogFactory.getLog((Class)OnEvent.class);
    private static final long serialVersionUID = 1L;

    public void messageReceived(ReceiveAction receiveAction, Token token) {
        ScopeInstance scopeInstance = Scope.getInstance(token);
        if (!scopeInstance.getState().equals(ActiveState.PERFORMING_PRIMARY_ACTIVITY)) {
            log.debug((Object)("message refused, scope no longer in '" + ActiveState.PERFORMING_PRIMARY_ACTIVITY + "' state: " + "token=" + token + ", scope=" + (Object)((Object)this.getCompositeActivity())));
            return;
        }
        Token eventToken = scopeInstance.createEventToken();
        this.getScope().createEventInstance(eventToken);
        if (this.variable != null) {
            this.variable.createInstance(eventToken);
        }
        this.execute(new ExecutionContext(eventToken));
    }

    public VariableDefinition findVariable(String name) {
        return this.variable != null && this.variable.getName().equals(name) ? this.variable : super.findVariable(name);
    }

    public ReceiveAction getReceiveAction() {
        if (this.action == null) {
            return null;
        }
        if (this.action instanceof ReceiveAction) {
            return (ReceiveAction)this.action;
        }
        Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
        ReceiveAction receiveAction = (ReceiveAction)hbSession.load(ReceiveAction.class, (Serializable)new Long(this.action.getId()));
        this.action = receiveAction;
        return receiveAction;
    }

    public void setAction(Action action) {
        if (!(action instanceof ReceiveAction)) {
            throw new IllegalArgumentException("not a receive action: " + action);
        }
        this.action = action;
        ((ReceiveAction)action).setInboundMessageActivity(this);
    }

    public VariableDefinition getVariableDefinition() {
        return this.variable;
    }

    public void setVariableDefinition(VariableDefinition variable) {
        this.variable = variable;
    }
}

