/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.scope;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.alarm.AlarmAction;
import org.jbpm.bpel.alarm.TimeDrivenActivity;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.state.ActiveState;
import org.jbpm.bpel.graph.scope.Handler;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class OnAlarm
extends Handler
implements TimeDrivenActivity {
    private static final Log log = LogFactory.getLog((Class)OnAlarm.class);
    private static final long serialVersionUID = 1L;

    public void alarmFired(AlarmAction alarmAction, Token token) {
        ScopeInstance scopeInstance = Scope.getInstance(token);
        if (!scopeInstance.getState().equals(ActiveState.PERFORMING_PRIMARY_ACTIVITY)) {
            log.debug((Object)("scope is no longer in normal processing mode, ignoring: alarm=" + (Object)((Object)alarmAction) + ", scope=" + (Object)((Object)this.getCompositeActivity())));
            return;
        }
        Token eventToken = scopeInstance.createEventToken();
        this.getScope().createEventInstance(eventToken);
        this.execute(new ExecutionContext(eventToken));
    }

    public AlarmAction getAlarmAction() {
        if (this.action == null) {
            return null;
        }
        if (this.action instanceof AlarmAction) {
            return (AlarmAction)this.action;
        }
        Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
        AlarmAction alarmAction = (AlarmAction)((Object)hbSession.load(AlarmAction.class, (Serializable)new Long(this.action.getId())));
        this.action = alarmAction;
        return alarmAction;
    }

    public void setAction(Action action) {
        if (!(action instanceof AlarmAction)) {
            throw new IllegalArgumentException("not an alarm action: " + action);
        }
        this.action = action;
        ((AlarmAction)action).setTimeDrivenActivity(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("alarm", (Object)this.action).toString();
    }
}

