/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.exe;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.alarm.AlarmAction;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.exe.Compensator;
import org.jbpm.bpel.graph.exe.FaultInstance;
import org.jbpm.bpel.graph.exe.ScopeInstanceIterator;
import org.jbpm.bpel.graph.exe.ScopeState;
import org.jbpm.bpel.graph.exe.state.ActiveState;
import org.jbpm.bpel.graph.exe.state.CompensatingState;
import org.jbpm.bpel.graph.exe.state.FaultingState;
import org.jbpm.bpel.graph.exe.state.TerminatingState;
import org.jbpm.bpel.graph.scope.Handler;
import org.jbpm.bpel.graph.scope.OnAlarm;
import org.jbpm.bpel.graph.scope.OnEvent;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.integration.IntegrationService;
import org.jbpm.bpel.integration.def.CorrelationSetDefinition;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.persistence.db.ScopeSession;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.def.VariableType;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.scheduler.SchedulerService;
import org.w3c.dom.Element;

public class ScopeInstance
implements Serializable,
Compensator {
    long id;
    private Scope definition;
    private ScopeState state;
    private Token token;
    private FaultInstance faultInstance;
    private Compensator compensator;
    private static final String PRIMARY_TOKEN = "primary";
    private static final String HANDLER_TOKEN = "handler";
    private static final String EVENT_TOKEN = "event";
    private static final String EVENTS_TOKEN = "events";
    private static final ScopeState[] TERMINATABLE_STATES = new ScopeState[]{ActiveState.PERFORMING_PRIMARY_ACTIVITY, ActiveState.COMPLETING_EVENTS, FaultingState.FAULTING_WITH_HANDLER, FaultingState.FAULTING_WITHOUT_HANDLER, CompensatingState.COMPENSATING_WITH_HANDLER, CompensatingState.COMPENSATING_WITHOUT_HANDLER, TerminatingState.TERMINATING_WITH_HANDLER, TerminatingState.TERMINATING_WITHOUT_HANDLER};
    private static final Predicate terminatableStatesPredicate = new StatePredicate(TERMINATABLE_STATES);
    private static final ScopeState[] NOT_ENDED_STATES = new ScopeState[]{ActiveState.PERFORMING_PRIMARY_ACTIVITY, ActiveState.COMPLETING_EVENTS, FaultingState.TERMINATING_PRIMARY_ACTIVITY, FaultingState.FAULTING_WITH_HANDLER, FaultingState.FAULTING_WITHOUT_HANDLER, FaultingState.TERMINATING_FAULT_HANDLER, CompensatingState.COMPENSATING_WITH_HANDLER, CompensatingState.COMPENSATING_WITHOUT_HANDLER, CompensatingState.TERMINATING_COMPENSATION_HANDLER, TerminatingState.TERMINATING_PRIMARY_ACTIVITY, TerminatingState.TERMINATING_WITH_HANDLER, TerminatingState.TERMINATING_WITHOUT_HANDLER, TerminatingState.TERMINATING_TERMINATION_HANDLER};
    private static final Predicate notEndedStatesPredicate = new StatePredicate(NOT_ENDED_STATES);
    private static final Log log = LogFactory.getLog((Class)ScopeInstance.class);
    private static final long serialVersionUID = 1L;

    protected ScopeInstance() {
    }

    public ScopeInstance(Scope definition, Token token) {
        this.definition = definition;
        this.token = token;
        this.setState(ActiveState.PERFORMING_PRIMARY_ACTIVITY);
        new Token(token, PRIMARY_TOKEN);
    }

    public void initializeData() {
        Iterator variableIt = this.definition.getVariables().values().iterator();
        while (variableIt.hasNext()) {
            ((VariableDefinition)variableIt.next()).createInstance(this.token);
        }
        Iterator correlationSetIt = this.definition.getCorrelationSets().values().iterator();
        while (correlationSetIt.hasNext()) {
            ((CorrelationSetDefinition)correlationSetIt.next()).createInstance(this.token);
        }
        Iterator partnerLinkIt = this.definition.getPartnerLinks().values().iterator();
        while (partnerLinkIt.hasNext()) {
            ((PartnerLinkDefinition)partnerLinkIt.next()).createInstance(this.token);
        }
    }

    public void faulted(FaultInstance faultInstance) {
        this.faultInstance = faultInstance;
        this.state.faulted(this);
    }

    public void terminate() {
        this.state.terminate(this);
    }

    public void compensate(Compensator compensator) {
        this.compensator = compensator;
        this.state.compensate(this);
    }

    public void completed() {
        this.state.completed(this);
    }

    public void scopeCompensated(ScopeInstance nestedInstance) {
        ScopeSession scopeSession = ScopeSession.getInstance(JbpmContext.getCurrentJbpmContext());
        ScopeInstance nextNestedInstance = scopeSession.nextChildToCompensate(this);
        if (nextNestedInstance != null) {
            nextNestedInstance.compensate(this);
        } else {
            this.state.childrenCompensated(this);
        }
    }

    public void scopeTerminated(ScopeInstance child) {
        FilterIterator childrenIt = new FilterIterator((Iterator)new ScopeInstanceIterator(this.token), terminatableStatesPredicate);
        if (!childrenIt.hasNext()) {
            this.state.childrenTerminated(this);
        }
    }

    public Handler getFaultHandler() {
        VariableType dataType;
        if (this.faultInstance == null) {
            throw new IllegalStateException("scope has not faulted");
        }
        MessageValue messageValue = this.faultInstance.getMessageValue();
        if (messageValue != null) {
            dataType = messageValue.getType();
        } else {
            Element elementValue = this.faultInstance.getElementValue();
            if (elementValue != null) {
                QName elementName = new QName(elementValue.getNamespaceURI(), elementValue.getLocalName());
                dataType = this.definition.getBpelProcessDefinition().getImportDefinition().getElementType(elementName);
            } else {
                dataType = null;
            }
        }
        return this.definition.selectFaultHandler(this.faultInstance.getName(), dataType);
    }

    public void enableEvents() {
        Collection onEvents = this.definition.getOnEvents();
        Collection onAlarms = this.definition.getOnAlarms();
        if (onEvents.isEmpty() && onAlarms.isEmpty()) {
            return;
        }
        Token eventToken = new Token(this.token, EVENTS_TOKEN);
        eventToken.setNode((Node)this.definition);
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        IntegrationService relationService = ReceiveAction.getIntegrationService(jbpmContext);
        Iterator onEventIt = onEvents.iterator();
        while (onEventIt.hasNext()) {
            OnEvent onEvent = (OnEvent)onEventIt.next();
            relationService.receive(onEvent.getReceiveAction(), eventToken);
        }
        SchedulerService schedulerService = AlarmAction.getSchedulerService(jbpmContext);
        Iterator alarmHandlerIt = onAlarms.iterator();
        while (alarmHandlerIt.hasNext()) {
            OnAlarm alarmHandler = (OnAlarm)alarmHandlerIt.next();
            alarmHandler.getAlarmAction().createTimer(eventToken, schedulerService);
        }
    }

    public void disableEvents() {
        Token eventsToken = this.getEventsToken();
        if (eventsToken == null) {
            return;
        }
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        IntegrationService integrationService = ReceiveAction.getIntegrationService(jbpmContext);
        Iterator onEventIt = this.definition.getOnEvents().iterator();
        while (onEventIt.hasNext()) {
            OnEvent onEvent = (OnEvent)onEventIt.next();
            integrationService.endReception(onEvent.getReceiveAction(), eventsToken);
        }
        SchedulerService schedulerService = AlarmAction.getSchedulerService(jbpmContext);
        Iterator onAlarmIt = this.definition.getOnAlarms().iterator();
        while (onAlarmIt.hasNext()) {
            OnAlarm onAlarm = (OnAlarm)onAlarmIt.next();
            onAlarm.getAlarmAction().deleteTimer(eventsToken, schedulerService);
        }
    }

    public void close() {
        Token parentToken = this.token.getParent();
        if (parentToken != null) {
            this.token.end(false);
            parentToken.getNode().leave(new ExecutionContext(parentToken));
        } else {
            this.token.end();
        }
    }

    public void terminateChildren() {
        Token primaryToken = this.getPrimaryToken();
        if (!primaryToken.hasEnded()) {
            ScopeInstance.terminateToken(primaryToken);
            Token eventsToken = this.getEventsToken();
            if (eventsToken != null && !eventsToken.hasEnded()) {
                this.disableEvents();
                Iterator eventTokenIt = eventsToken.getChildren().values().iterator();
                while (eventTokenIt.hasNext()) {
                    Token eventToken = (Token)eventTokenIt.next();
                    if (eventToken.hasEnded()) continue;
                    ScopeInstance.terminateToken(eventToken);
                }
                eventsToken.end(false);
            }
        } else {
            Token handlerToken = this.getHandlerToken();
            if (handlerToken != null && !handlerToken.hasEnded()) {
                ScopeInstance.terminateToken(handlerToken);
            }
        }
        FilterIterator nestedScopeIt = new FilterIterator((Iterator)new ScopeInstanceIterator(this.token), terminatableStatesPredicate);
        if (!nestedScopeIt.hasNext()) {
            this.state.childrenTerminated(this);
        }
    }

    private static void terminateToken(Token token) {
        Activity activity = (Activity)token.getNode();
        activity.terminate(new ExecutionContext(token));
        token.end(false);
    }

    public boolean hasPendingEvents() {
        Token eventToken = this.getEventsToken();
        if (eventToken == null) {
            return false;
        }
        FilterIterator scopeInstanceIt = new FilterIterator((Iterator)new ScopeInstanceIterator(eventToken), notEndedStatesPredicate);
        return scopeInstanceIt.hasNext();
    }

    public Token getPrimaryToken() {
        return this.token.getChild(PRIMARY_TOKEN);
    }

    public Token createEventToken() {
        Token eventsToken = this.getEventsToken();
        Map eventTokens = eventsToken.getChildren();
        return new Token(eventsToken, EVENT_TOKEN + (eventTokens != null ? eventTokens.size() : 0));
    }

    public Token createHandlerToken() {
        if (this.getHandlerToken() != null) {
            throw new IllegalStateException("handler token already exists");
        }
        return new Token(this.token, HANDLER_TOKEN);
    }

    public Token getHandlerToken() {
        return this.token.getChild(HANDLER_TOKEN);
    }

    private Token getEventsToken() {
        return this.token.getChild(EVENTS_TOKEN);
    }

    public Map getEventTokens() {
        return this.getEventsToken().getChildren();
    }

    public Token getEventToken(int index) {
        return this.getEventsToken().getChild(EVENT_TOKEN + index);
    }

    public ScopeState getState() {
        return this.state;
    }

    public void setState(ScopeState state) {
        log.debug((Object)("state change to '" + state + "' on '" + (Object)((Object)this.definition) + "' for '" + this.token + '\''));
        this.state = state;
    }

    public FaultInstance getFaultInstance() {
        return this.faultInstance;
    }

    public void setFaultInstance(FaultInstance faultInstance) {
        this.faultInstance = faultInstance;
    }

    public Compensator getCompensator() {
        return this.compensator;
    }

    public void setCompensator(Compensator compensator) {
        this.compensator = compensator;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public Scope getDefinition() {
        return this.definition;
    }

    public ScopeInstance getParent() {
        Token parentToken = this.token.getParent();
        return parentToken != null ? Scope.getInstance(parentToken) : null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this).append("name", (Object)this.definition.getName()).append("token", (Object)this.token.getFullName()).append("state", (Object)this.state);
        if (this.faultInstance != null) {
            builder.append("fault", (Object)this.faultInstance);
        }
        if (this.compensator != null) {
            builder.append("compensator", (Object)this.compensator);
        }
        return builder.append("id", this.id).toString();
    }

    private static class StatePredicate
    implements Predicate {
        private final ScopeState[] states;

        private StatePredicate(ScopeState[] states) {
            this.states = states;
        }

        public boolean evaluate(Object obj) {
            ScopeInstance scopeInstance = (ScopeInstance)obj;
            return ArrayUtils.contains((Object[])this.states, (Object)scopeInstance.getState());
        }
    }
}

