/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.basic;

import java.io.Serializable;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.integration.IntegrationService;
import org.jbpm.bpel.integration.def.InboundMessageActivity;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class Receive
extends Activity
implements InboundMessageActivity {
    private boolean createInstance;
    private static final long serialVersionUID = 1L;

    public Receive() {
    }

    public Receive(String name) {
        super(name);
    }

    public void terminate(ExecutionContext exeContext) {
        IntegrationService integrationService = ReceiveAction.getIntegrationService(exeContext.getJbpmContext());
        integrationService.endReception(this.getReceiveAction(), exeContext.getToken());
    }

    public void messageReceived(ReceiveAction receiveAction, Token token) {
        IntegrationService integrationService = ReceiveAction.getIntegrationService(JbpmContext.getCurrentJbpmContext());
        integrationService.endReception(receiveAction, token);
        this.leave(new ExecutionContext(token));
    }

    public ReceiveAction getReceiveAction() {
        if (this.action == null) {
            return null;
        }
        if (this.action instanceof ReceiveAction) {
            return (ReceiveAction)this.action;
        }
        Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
        ReceiveAction receiveAction = (ReceiveAction)hbSession.load(ReceiveAction.class, (Serializable)new Long(this.action.getId()));
        this.action = receiveAction;
        return receiveAction;
    }

    public void setAction(Action action) {
        if (!(action instanceof ReceiveAction)) {
            throw new IllegalArgumentException("not a receive action: " + action);
        }
        this.action = action;
        action.setName(this.name);
        ((ReceiveAction)action).setInboundMessageActivity(this);
    }

    public boolean isCreateInstance() {
        return this.createInstance;
    }

    public void setCreateInstance(boolean createInstance) {
        this.createInstance = createInstance;
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }
}

