/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.app;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.app.AppDescriptor;
import org.jbpm.bpel.app.AppDescriptorVisitor;
import org.jbpm.bpel.app.AppPartnerLink;
import org.jbpm.bpel.app.AppScope;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.scope.Scope;

public class ScopeMatcher
implements AppDescriptorVisitor {
    private final Scope parent;
    private final Map scopeDescriptors;

    public ScopeMatcher(BpelProcessDefinition processDefinition) {
        this.parent = processDefinition.getGlobalScope();
        this.scopeDescriptors = new HashMap();
    }

    private ScopeMatcher(Scope parent, Map scopeDescriptors) {
        this.parent = parent;
        this.scopeDescriptors = scopeDescriptors;
    }

    public Map getScopeDescriptors() {
        return this.scopeDescriptors;
    }

    public void visit(AppDescriptor appDescriptor) {
        this.scopeDescriptors.put(this.parent, appDescriptor);
        this.propagate(appDescriptor);
    }

    public void visit(AppScope appScope) {
        Scope scope = this.findScope(appScope.getName(), this.parent);
        if (scope != null) {
            this.scopeDescriptors.put(scope, appScope);
            new ScopeMatcher(scope, this.scopeDescriptors).propagate(appScope);
        }
    }

    public void visit(AppPartnerLink appPartnerLink) {
    }

    private void propagate(AppScope parentAppScope) {
        Iterator appScopeIt = parentAppScope.getScopes().iterator();
        while (appScopeIt.hasNext()) {
            AppScope appScope = (AppScope)appScopeIt.next();
            appScope.accept(this);
        }
    }

    private Scope findScope(String appScopeName, CompositeActivity parent) {
        Scope matchingScope = null;
        Iterator activityIt = parent.getNodes().iterator();
        while (activityIt.hasNext()) {
            Scope scope;
            Activity activity = (Activity)((Object)activityIt.next());
            if (!(activity instanceof CompositeActivity)) continue;
            if (activity instanceof Scope && (appScopeName != null ? appScopeName.equals(activity.getName()) : activity.isNameGenerated())) {
                if (matchingScope != null) {
                    throw new BpelException("conflicting scope name: " + appScopeName);
                }
                matchingScope = (Scope)activity;
            }
            if ((scope = this.findScope(appScopeName, (CompositeActivity)activity)) == null) continue;
            if (matchingScope != null) {
                throw new BpelException("conflicting scope name: " + appScopeName);
            }
            matchingScope = scope;
        }
        return matchingScope;
    }
}

